"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesActions = SeriesActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../../hooks/use_series_storage");
var _use_discover_link = require("../../hooks/use_discover_link");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/series_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SeriesActions({
  seriesId,
  series,
  seriesConfig,
  onEditClick
}) {
  const {
    setSeries,
    removeSeries,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    href: discoverHref
  } = (0, _use_discover_link.useDiscoverLink)({
    series,
    seriesConfig
  });
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[series.dataType];
  const deleteDisabled = seriesId === 0 && allSeries.length > 1;
  const copySeries = () => {
    let copySeriesId = `${series.name}-copy`;
    if (allSeries.find(({
      name
    }) => name === copySeriesId)) {
      copySeriesId = copySeriesId + allSeries.length;
    }
    setSeries(allSeries.length, {
      ...series,
      name: copySeriesId,
      breakdown: undefined
    });
    closePopover();
  };
  const toggleSeries = () => {
    if (series.hidden) {
      setSeries(seriesId, {
        ...series,
        hidden: undefined
      });
    } else {
      setSeries(seriesId, {
        ...series,
        hidden: true
      });
    }
    closePopover();
  };
  const closePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, [setPopover]);
  const onRemoveSeriesClick = (0, _react.useCallback)(() => {
    removeSeries(seriesId);
    closePopover();
  }, [removeSeries, seriesId, closePopover]);
  const changePopoverVisibility = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [setPopover, isPopoverOpen]);
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "exploratoryViewSeriesActionsButton",
    iconType: "boxesHorizontal",
    onClick: changePopoverVisibility,
    color: "text",
    "aria-label": POPOVER_BUTTON_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "flexEnd",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: EDIT_SERIES_LABEL,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    color: "text",
    "aria-label": EDIT_SERIES_LABEL,
    size: "s",
    onClick: onEditClick,
    "data-test-subj": `editSeries${seriesId}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "aria-label": ACTIONS_CONTEXT_MENU_LABEL,
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "viewSampleDocuments",
      icon: "discoverApp",
      href: discoverHref,
      "aria-label": VIEW_SAMPLE_DOCUMENTS_LABEL,
      disabled: !series.dataType || !series.selectedMetricField || !dataView,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, VIEW_SAMPLE_DOCUMENTS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "hideSeries",
      icon: series.hidden ? 'eye' : 'eyeClosed',
      onClick: toggleSeries,
      "aria-label": series.hidden ? SHOW_SERIES_LABEL : HIDE_SERIES_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }, series.hidden ? SHOW_SERIES_LABEL : HIDE_SERIES_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "copySeries",
      icon: "copy",
      onClick: copySeries,
      "aria-label": COPY_SERIES_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }, COPY_SERIES_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "deleteSeries",
      icon: "trash",
      onClick: onRemoveSeriesClick,
      "aria-label": DELETE_SERIES_LABEL,
      disabled: deleteDisabled,
      toolTipContent: deleteDisabled ? DELETE_SERIES_TOOLTIP_LABEL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    }, DELETE_SERIES_LABEL)],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }))));
}
const EDIT_SERIES_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.edit', {
  defaultMessage: 'Edit series'
});
const HIDE_SERIES_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.hide', {
  defaultMessage: 'Hide series'
});
const SHOW_SERIES_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.show', {
  defaultMessage: 'Show series'
});
const COPY_SERIES_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.clone', {
  defaultMessage: 'Duplicate series'
});
const DELETE_SERIES_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.removeSeries', {
  defaultMessage: 'Remove series'
});
const DELETE_SERIES_TOOLTIP_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.removeSeriesDisabled', {
  defaultMessage: 'Main series cannot be removed. Please remove all series below before you can remove this.'
});
const VIEW_SAMPLE_DOCUMENTS_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.sampleDocuments', {
  defaultMessage: 'View transaction in Discover'
});
const POPOVER_BUTTON_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.popoverButtonLabel', {
  defaultMessage: 'View series actions'
});
const ACTIONS_CONTEXT_MENU_LABEL = _i18n.i18n.translate('xpack.exploratoryView.seriesEditor.actionsAriaContextLabel', {
  defaultMessage: 'Series actions list'
});