"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (command, ast, context) => {
  const messages = [];
  if (!(context !== null && context !== void 0 && context.columns.get('_id'))) {
    messages.push((0, _utils.buildMissingMetadataMessage)(command, '_id'));
  }
  if (!(context !== null && context !== void 0 && context.columns.get('_index'))) {
    messages.push((0, _utils.buildMissingMetadataMessage)(command, '_index'));
  }
  if (!(context !== null && context !== void 0 && context.columns.get('_score'))) {
    messages.push((0, _utils.buildMissingMetadataMessage)(command, '_score'));
  }
  return messages;
};
exports.validate = validate;