"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsModified = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _addonActions = require("@storybook/addon-actions");
var _components = require("../../../components");
var _use_form = require("../../hooks/use_form");
var _use_form_is_modified = require("../../hooks/use_form_is_modified");
var _form = require("../form");
var _use_field = require("../use_field");
var _constants = require("./constants");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/form_is_modified.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IsModified = args => {
  const {
    form
  } = (0, _use_form.useForm)();
  const isFormModified = (0, _use_form_is_modified.useFormIsModified)({
    form
  });
  (0, _react.useEffect)(() => {
    (0, _addonActions.action)('Is form modified')(isFormModified);
  }, [isFormModified]);
  return /*#__PURE__*/_react.default.createElement(_form.Form, (0, _extends2.default)({
    form: form
  }, args, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "title",
    defaultValue: "Initial value",
    component: _components.TextField,
    config: _constants.titleConfigBase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "isOn",
    defaultValue: true,
    component: _components.ToggleField,
    config: {
      label: 'Is on'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => (0, _form_utils.submitForm)(form),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, "Send"));
};
exports.IsModified = IsModified;
IsModified.parameters = {
  docs: {
    source: {
      code: `
const MyFormComponent = () => {
  const { form } = useForm();
  const isFormModified = useFormIsModified({ form });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  useEffect(() => {
    // Do something whenever the form is modified
  }, [isFormModified]);

  return (
    <Form form={form} {...args}>
      <UseField<string>
        path="title"
        defaultValue="Initial value"
        component={TextField}
        config={titleConfigBase}
      />
      <UseField<boolean>
        path="isOn"
        defaultValue={true}
        component={ToggleField}
        config={{ label: 'Is on' }}
      />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};