"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDateInPast = validateDateInPast;
exports.validateDateRangeOrder = validateDateRangeOrder;
exports.validateESDate = validateESDate;
exports.validateStringDateRange = validateStringDateRange;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _validation_error = require("./validation_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateStringDateRange(from, to) {
  const parsedFrom = validateESDate(from);
  validateDateInPast(parsedFrom);
  if (to) {
    const parsedTo = validateESDate(to);
    validateDateRangeOrder(parsedFrom, parsedTo);
  }
}
function validateDateInPast(date) {
  const now = _datemath.default.parse('now');
  if (date.isAfter(now)) {
    throw new _validation_error.AssetsValidationError(`Date cannot be in the future ${date.toISOString()}`, {
      statusCode: 400
    });
  }
}
function validateDateRangeOrder(from, to) {
  if (from.isAfter(to)) {
    throw new _validation_error.AssetsValidationError(`Invalid date range - given "from" value (${from.toISOString()}) is after given "to" value (${to.toISOString()})`, {
      statusCode: 400
    });
  }
}
function validateESDate(dateString) {
  try {
    const parsed = _datemath.default.parse(dateString);
    if (typeof parsed === 'undefined') {
      throw new Error('Date string was parsed as undefined');
    }
    if (parsed.toString() === 'Invalid date') {
      throw new Error('Date string produced an invalid date');
    }
    return parsed;
  } catch (error) {
    throw new _validation_error.AssetsValidationError(`"${dateString}" is not a valid Elasticsearch date value - ${error}`, {
      statusCode: 400
    });
  }
}