"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEntitiesResetIndexTemplateConfig = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _generate_component_id = require("../helpers/generate_component_id");
var _constants_entities = require("../../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEntitiesResetIndexTemplateConfig = definition => ({
  name: (0, _generate_component_id.generateResetIndexTemplateId)(definition),
  _meta: {
    description: "Index template for indices managed by the Elastic Entity Model's entity discovery framework for the reset dataset",
    ecs_version: '8.0.0',
    managed: true,
    managed_by: 'security_context_core_analysis'
  },
  composed_of: [_constants_entities.ECS_MAPPINGS_COMPONENT_TEMPLATE, _constants_entities.ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1, _constants_entities.ENTITY_ENTITY_COMPONENT_TEMPLATE_V1, _constants_entities.ENTITY_EVENT_COMPONENT_TEMPLATE_V1],
  index_patterns: [(0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_RESET,
    definitionId: definition.id
  })],
  priority: 200,
  template: {
    aliases: {
      [(0, _entitiesSchema.entitiesAliasPattern)({
        type: definition.type,
        dataset: _entitiesSchema.ENTITY_RESET
      })]: {}
    }
  }
});
exports.generateEntitiesResetIndexTemplateConfig = generateEntitiesResetIndexTemplateConfig;