"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAliasIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAliasIndices = async (client, aliasName) => {
  const aliasIndices = await client.asCurrentUser.indices.getAlias({
    name: aliasName
  });
  return Object.keys(aliasIndices).sort();
};
exports.fetchAliasIndices = fetchAliasIndices;