"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSyncRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../shared/doc_links");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_view_logic = require("../../../connector_detail/connector_view_logic");
var _filtering_rules_table = require("../../../shared/filtering_rules_table/filtering_rules_table");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _edit_sync_rules_flyout = require("./edit_sync_rules_flyout");
var _sync_rules_callouts = require("./sync_rules_callouts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/connector/sync_rules/connector_rules.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectorSyncRules = () => {
  const {
    indexName,
    hasAdvancedFilteringFeature,
    hasBasicFilteringFeature
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    applyDraft,
    setLocalFilteringRules,
    setLocalAdvancedSnippet,
    setIsEditing
  } = (0, _kea.useActions)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    advancedSnippet,
    draftErrors,
    draftState,
    filteringRules,
    hasDraft,
    isEditing
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditing && /*#__PURE__*/_react.default.createElement(_edit_sync_rules_flyout.EditSyncRulesFlyout, {
    errors: draftErrors,
    hasAdvancedFilteringFeature: hasAdvancedFilteringFeature,
    hasBasicFilteringFeature: hasBasicFilteringFeature,
    revertLocalFilteringRules: () => setLocalFilteringRules(filteringRules),
    revertLocalAdvancedFiltering: () => setLocalAdvancedSnippet(advancedSnippet),
    setIsEditing: setIsEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, hasDraft && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sync_rules_callouts.SyncRulesStateCallouts, {
    applyDraft: applyDraft,
    editDraft: () => setIsEditing(true),
    state: draftState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.description', {
    defaultMessage: `Include or exclude high level items, file types and (file or folder) paths to
                    synchronize from {indexName}. Everything is included by default. Each document is
                    tested against the rules below and the first rule that matches will be applied.`,
    values: {
      indexName
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.syncRulesLabel', {
    defaultMessage: 'Learn more about sync rules'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchConnectorSyncRulesButton",
    "data-telemetry-id": "entSearchContent-connector-syncRules-editRules-editDraftRules",
    color: "primary",
    onClick: () => setIsEditing(!isEditing),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, hasDraft ? _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.editFilterRulesTitle', {
    defaultMessage: 'Edit sync rules'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.draftNewFilterRulesTitle', {
    defaultMessage: 'Draft new sync rules'
  }))))), hasBasicFilteringFeature && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.basicRulesTitle', {
    defaultMessage: 'Basic rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.basicRulesDescription', {
    defaultMessage: 'These rules apply to documents during the integration filtering phase.'
  })))), /*#__PURE__*/_react.default.createElement(_filtering_rules_table.FilteringRulesTable, {
    filteringRules: filteringRules,
    showOrder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  })))), hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesTitle', {
    defaultMessage: 'Advanced rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedFiltersDescription', {
    defaultMessage: 'These rules apply before the data is obtained from the data source.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    external: true,
    href: _doc_links.docLinks.syncRulesAdvanced,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedFiltersLinkTitle', {
    defaultMessage: 'Learn more about advanced sync rules.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "json",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 17
    }
  }, advancedSnippet), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesCalloutTitle', {
      defaultMessage: 'Configuration'
    }),
    color: "warning",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesCalloutDescription', {
    defaultMessage: 'This advanced sync rule might override some configuration fields.'
  }))))))))));
};
exports.ConnectorSyncRules = ConnectorSyncRules;