"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../shared/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/components/header_actions/search_playground_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchPlaygroundPopover = ({
  indexName,
  ingestionMethod
}) => {
  const {
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const onStartPlaygroundClick = (0, _react.useCallback)(() => {
    if (!share) return;
    const playgroundLocator = share.url.locators.get('PLAYGROUND_LOCATOR_ID');
    if (playgroundLocator) {
      playgroundLocator.navigate({
        'default-index': indexName
      });
    }
  }, [indexName, share]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchSearchPlaygroundPopoverViewInPlaygroundButton",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-viewPlayground`,
    iconType: "eye",
    onClick: onStartPlaygroundClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.viewPlayground', {
    defaultMessage: 'View in Playground'
  }));
};
exports.SearchPlaygroundPopover = SearchPlaygroundPopover;