"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatCard = exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _searchConnectors = require("@kbn/search-connectors");
var _encode_path_params = require("../../../shared/encode_path_params");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _agentless_status_badge = require("./agentless_status_badge");
var _connector_detail = require("./connector_detail");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/connector_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatCard = ({
  title,
  content,
  footer
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, content))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, footer));
};
exports.StatCard = StatCard;
const seeDocumentsLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.seeDocumentsTextLabel', {
  defaultMessage: 'See documents'
});
const pipelinesLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.managePipelines', {
  defaultMessage: 'Manage pipelines'
});
const configureLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.configureLink', {
  defaultMessage: 'Configure'
});
const noAgentLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noAgentFound', {
  defaultMessage: 'No agent found'
});
const noPolicyLabel = _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noPolicyFound', {
  defaultMessage: 'No policy found'
});
const ConnectorStats = ({
  connector,
  indexData,
  agentlessOverview
}) => {
  var _connectorDefinition$, _indexData$count;
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    services: {
      discover
    }
  } = (0, _public.useKibana)();
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  // TODO service_type === "" is considered unknown/custom connector multiple places replace all of them with a better solution
  const CUSTOM_CONNECTOR = (0, _react.useMemo)(() => connectorTypes.filter(({
    serviceType
  }) => serviceType === ''), [connectorTypes]);
  const connectorDefinition = connectorTypes.find(c => c.serviceType === connector.service_type) || CUSTOM_CONNECTOR[0];
  const columns = connector.is_native ? 2 : 3;
  const agnetlessPolicyExists = !!(agentlessOverview !== null && agentlessOverview !== void 0 && agentlessOverview.policy);
  const agentlessAgentExists = !!(agentlessOverview !== null && agentlessOverview !== void 0 && agentlessOverview.agent);
  const navigateToDiscoverPayload = agentlessAgentExists ? {
    dataViewId: 'logs-*',
    filters: [{
      meta: {
        key: 'labels.connector_id',
        index: 'logs-*',
        type: 'phrase',
        params: connector.id
      },
      query: {
        match_phrase: {
          'labels.connector_id': connector.id
        }
      }
    }, {
      meta: {
        key: 'elastic_agent.id',
        index: 'logs-*',
        type: 'phrase',
        params: connector.id
      },
      query: {
        match_phrase: {
          'elastic_agent.id': agentlessOverview.agent.id
        }
      }
    }],
    timeRange: {
      from: 'now-6h',
      to: 'now'
    },
    columns: ['message', 'log.level', 'labels.sync_job_id']
  } : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.h4.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      responsive: false,
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, connectorDefinition && connectorDefinition.iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: connectorDefinition.iconPath,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 19
      }
    }, (_connectorDefinition$ = connectorDefinition === null || connectorDefinition === void 0 ? void 0 : connectorDefinition.name) !== null && _connectorDefinition$ !== void 0 ? _connectorDefinition$ : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _connector_status_helpers.connectorStatusToColor)(connector),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 17
      }
    }, (0, _connector_status_helpers.connectorStatusToText)(connector)))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.connectors.connectorStats.connectorIdLabel",
      defaultMessage: "ID: {connectorId}",
      values: {
        connectorId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 40
          }
        }, connector.id)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 23
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: connector.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 21
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      color: "text",
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.copyConnectorIdButton', {
        defaultMessage: 'Copy Connector ID'
      }),
      "data-test-subj": "copyConnectorIdButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 25
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 15
      }
    }, [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.CONFIGURED].includes(connector.status) && connector.index_name ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 19
      }
    }, configureLabel) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      color: "primary",
      size: "s",
      fill: true,
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 19
      }
    }, configureLabel))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.indexTitle', {
      defaultMessage: 'Attached index'
    }),
    content: connector.index_name ? indexData ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 21
      }
    }, connector.index_name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.conectors.indexHealth', {
      defaultMessage: 'Healthy'
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.indexDoesntExistLabel', {
      defaultMessage: "Index doesn't exist"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noIndexLabel', {
      defaultMessage: 'No index attached yet'
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "documents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.p.DocumentsLabel', {
      defaultMessage: '{documentAmount} Documents',
      values: {
        documentAmount: (_indexData$count = indexData === null || indexData === void 0 ? void 0 : indexData.count) !== null && _indexData$count !== void 0 ? _indexData$count : 0
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      isDisabled: !(connector.index_name && indexData),
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.DOCUMENTS
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 17
      }
    }, seeDocumentsLabel))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.pipelinesTitle', {
      defaultMessage: 'Pipelines'
    }),
    content: connector.pipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 19
      }
    }, connector.pipeline.name))) : _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.noPipelineText', {
      defaultMessage: 'None'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
      isDisabled: !connector.index_name,
      size: "s",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: connector.id,
        tabId: _connector_detail.ConnectorDetailTabId.PIPELINES
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 17
      }
    }, pipelinesLabel))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 9
    }
  })), connector.is_native && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StatCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.integrationTitle', {
      defaultMessage: 'Integration'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 410,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 411,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !connector.service_type,
      iconType: "plugs",
      color: "text",
      href: http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_INTEGRATION_DETAIL_PATH, {
        serviceType: connector.service_type || ''
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.elasticConnectorsButton', {
      defaultMessage: 'Elastic Connectors'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 17
      }
    }, agentlessAgentExists ? /*#__PURE__*/_react.default.createElement(_agentless_status_badge.AgentlessConnectorStatusBadge, {
      status: agentlessOverview === null || agentlessOverview === void 0 ? void 0 : agentlessOverview.agent.status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 21
      }
    }, noAgentLabel))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "connectorStatsViewLogsButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.viewLogsButtonLabel', {
        defaultMessage: 'View logs'
      }),
      disabled: !agentlessAgentExists,
      iconType: "discoverApp",
      onClick: () => {
        var _discover$locator;
        (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate(navigateToDiscoverPayload);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.viewLogsButtonLabel', {
      defaultMessage: 'View logs'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 17
      }
    }, agentlessAgentExists && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !agentlessOverview || !agentlessOverview.agent.id,
      size: "s",
      href: http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.FLEET_AGENT_DETAIL_PATH, {
        agentId: agentlessOverview.agent.id
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.hostOverview', {
      defaultMessage: 'Host overview'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 480,
        columnNumber: 17
      }
    }, agnetlessPolicyExists ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isDisabled: !agentlessOverview || !agentlessOverview.policy.id,
      size: "s",
      href: http.basePath.prepend((0, _encode_path_params.generateEncodedPath)(_routes.FLEET_POLICY_DETAIL_PATH, {
        policyId: agentlessOverview.policy.id
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.connectorStats.managePolicy', {
      defaultMessage: 'Manage policy'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 499,
        columnNumber: 21
      }
    }, noPolicyLabel))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 11
    }
  })));
};
exports.ConnectorStats = ConnectorStats;