"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _add_indices_flyout = require("./add_indices_flyout");
var _search_application_indices = require("./search_application_indices");
var _search_application_indices_logic = require("./search_application_indices_logic");
var _search_application_schema = require("./search_application_schema");
var _search_application_view_logic = require("./search_application_view_logic");
var Styles = _interopRequireWildcard(require("./styles"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/search_application_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const pageTitle = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.pageTitle', {
  defaultMessage: 'Content'
});
const INDICES_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.indicesTabTitle', {
  defaultMessage: 'Indices'
});
const SCHEMA_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.schemaTabTitle', {
  defaultMessage: 'Schema'
});
const getTabBreadCrumb = tabId => {
  switch (tabId) {
    case _routes.SearchApplicationContentTabs.INDICES:
      return INDICES_TAB_TITLE;
    case _routes.SearchApplicationContentTabs.SCHEMA:
      return SCHEMA_TAB_TITLE;
    default:
      return tabId;
  }
};
const SearchApplicationContent = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    searchApplicationName,
    isLoadingSearchApplication,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    addIndicesFlyoutOpen
  } = (0, _kea.useValues)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    closeAddIndicesFlyout,
    openAddIndicesFlyout
  } = (0, _kea.useActions)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    contentTabId = _routes.SearchApplicationContentTabs.INDICES
  } = (0, _reactRouterDom.useParams)();
  const onTabClick = tab => () => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: tab,
      searchApplicationName
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [searchApplicationName, pageTitle, getTabBreadCrumb(contentTabId)],
    pageViewTelemetry: _routes.SearchApplicationViewTabs.CONTENT,
    isLoading: isLoadingSearchApplication,
    pageHeader: {
      bottomBorder: false,
      breadcrumbs: [{
        color: 'primary',
        onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_PATH, {
          searchApplicationName
        })),
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 17
          }
        }), " ", searchApplicationName)
      }],
      css: Styles.searchApplicationHeaderBackgroundColor(euiTheme),
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchApplications-indices-addNewIndices",
        "data-test-subj": "search-application-add-new-indices-btn",
        iconType: "plusInCircle",
        fill: true,
        onClick: openAddIndicesFlyout,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addNewIndicesButton', {
        defaultMessage: 'Add new indices'
      }))],
      tabs: [{
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.INDICES,
        label: INDICES_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationContentTabs.INDICES)
      }, {
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.SCHEMA,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 15
          }
        }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 40
          }
        }), SCHEMA_TAB_TITLE),
        onClick: onTabClick(_routes.SearchApplicationContentTabs.SCHEMA)
      }]
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, contentTabId === _routes.SearchApplicationContentTabs.INDICES && /*#__PURE__*/_react.default.createElement(_search_application_indices.SearchApplicationIndices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 65
    }
  }), contentTabId === _routes.SearchApplicationContentTabs.SCHEMA && /*#__PURE__*/_react.default.createElement(_search_application_schema.SearchApplicationSchema, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 64
    }
  }), addIndicesFlyoutOpen && /*#__PURE__*/_react.default.createElement(_add_indices_flyout.AddIndicesFlyout, {
    onClose: closeAddIndicesFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 32
    }
  }));
};
exports.SearchApplicationContent = SearchApplicationContent;