"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _app_context = require("../services/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "assistantService", void 0);
    (0, _defineProperty2.default)(this, "adhocAttackDiscoveryDataClient", void 0);
    this.options = options;
    this.logger = options.logger;
    this.assistantService = options.assistantService;
    this.adhocAttackDiscoveryDataClient = options.adhocAttackDiscoveryDataClient;
  }
  async create(context, request, eventLogIndex, eventLogger) {
    var _coreStart$security$a;
    const {
      options
    } = this;
    const {
      core,
      plugins
    } = options;
    const [coreStart, startPlugins] = await core.getStartServices();
    const coreContext = await context.core;
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
    };
    const getCurrentUser = async () => {
      var _contextUser;
      let contextUser = coreContext.security.authc.getCurrentUser();
      if (contextUser && !((_contextUser = contextUser) !== null && _contextUser !== void 0 && _contextUser.profile_uid)) {
        try {
          const users = await coreContext.elasticsearch.client.asCurrentUser.security.getUser({
            username: contextUser.username,
            with_profile_uid: true
          });
          if (users[contextUser.username].profile_uid) {
            contextUser = {
              ...contextUser,
              profile_uid: users[contextUser.username].profile_uid
            };
          }
        } catch (e) {
          this.logger.error(`Failed to get user profile_uid: ${e}`);
        }
      }
      return contextUser;
    };
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const rulesClient = await startPlugins.alerting.getRulesClientWithRequest(request);
    const actionsClient = await startPlugins.actions.getActionsClientWithRequest(request);
    return {
      core: coreContext,
      userProfile: coreStart.userProfile,
      actions: startPlugins.actions,
      auditLogger: (_coreStart$security$a = coreStart.security.audit) === null || _coreStart$security$a === void 0 ? void 0 : _coreStart$security$a.asScoped(request),
      logger: this.logger,
      eventLogIndex,
      /** for writing to the event log */
      eventLogger,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getSpaceId,
      getCurrentUser,
      getRegisteredTools: pluginName => {
        return _app_context.appContextService.getRegisteredTools(pluginName);
      },
      getRegisteredFeatures: pluginName => {
        return _app_context.appContextService.getRegisteredFeatures(pluginName);
      },
      checkPrivileges: () => {
        return startPlugins.security.authz.checkPrivilegesWithRequest(request);
      },
      llmTasks: startPlugins.llmTasks,
      inference: startPlugins.inference,
      savedObjectsClient,
      telemetry: core.analytics,
      // Note: elserInferenceId is used here to enable setting up the KB using a different ELSER model, which
      // is necessary for testing purposes (`pt_tiny_elser`).
      getAIAssistantKnowledgeBaseDataClient: (0, _lodash.memoize)(async params => {
        const currentUser = await getCurrentUser();
        const {
          securitySolutionAssistant
        } = await coreStart.capabilities.resolveCapabilities(request, {
          capabilityPath: 'securitySolutionAssistant.*'
        });
        return this.assistantService.createAIAssistantKnowledgeBaseDataClient({
          spaceId: getSpaceId(),
          logger: this.logger,
          licensing: context.licensing,
          currentUser,
          elserInferenceId: params === null || params === void 0 ? void 0 : params.elserInferenceId,
          manageGlobalKnowledgeBaseAIAssistant: securitySolutionAssistant.manageGlobalKnowledgeBaseAIAssistant,
          // uses internal user to interact with ML API
          getTrainedModelsProvider: () => plugins.ml.trainedModelsProvider({}, coreStart.savedObjects.createInternalRepository())
        });
      }),
      getAttackDiscoveryDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createAttackDiscoveryDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser,
          adhocAttackDiscoveryDataClient: this.adhocAttackDiscoveryDataClient
        });
      }),
      getAttackDiscoverySchedulingDataClient: (0, _lodash.memoize)(async () => {
        return this.assistantService.createAttackDiscoverySchedulingDataClient({
          actionsClient,
          logger: this.logger,
          rulesClient
        });
      }),
      getDefendInsightsDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createDefendInsightsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantPromptsDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createAIAssistantPromptsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAlertSummaryDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createAlertSummaryDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantAnonymizationFieldsDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createAIAssistantAnonymizationFieldsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantConversationsDataClient: (0, _lodash.memoize)(async params => {
        const currentUser = await getCurrentUser();
        return this.assistantService.createAIAssistantConversationsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser,
          contentReferencesEnabled: params === null || params === void 0 ? void 0 : params.contentReferencesEnabled
        });
      }),
      getCheckpointSaver: (0, _lodash.memoize)(async () => {
        if (!this.assistantService.getIsCheckpointSaverEnabled()) {
          return null;
        }
        const currentUser = await getCurrentUser();
        return this.assistantService.createCheckpointSaver({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      })
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;