"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestHasRequiredAnonymizationParams = exports.getLangChainMessages = exports.getLangChainMessage = void 0;
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLangChainMessage = assistantMessage => {
  var _assistantMessage$con, _assistantMessage$con2, _assistantMessage$con3, _assistantMessage$con4;
  switch (assistantMessage.role) {
    case 'system':
      return new _messages.SystemMessage((_assistantMessage$con = assistantMessage.content) !== null && _assistantMessage$con !== void 0 ? _assistantMessage$con : '');
    case 'user':
      return new _messages.HumanMessage((_assistantMessage$con2 = assistantMessage.content) !== null && _assistantMessage$con2 !== void 0 ? _assistantMessage$con2 : '');
    case 'assistant':
      return new _messages.AIMessage((_assistantMessage$con3 = assistantMessage.content) !== null && _assistantMessage$con3 !== void 0 ? _assistantMessage$con3 : '');
    default:
      return new _messages.HumanMessage((_assistantMessage$con4 = assistantMessage.content) !== null && _assistantMessage$con4 !== void 0 ? _assistantMessage$con4 : '');
  }
};
exports.getLangChainMessage = getLangChainMessage;
const getLangChainMessages = assistantMessages => assistantMessages.map(getLangChainMessage);
exports.getLangChainMessages = getLangChainMessages;
const requestHasRequiredAnonymizationParams = request => {
  var _request$body;
  const {
    replacements
  } = (_request$body = request === null || request === void 0 ? void 0 : request.body) !== null && _request$body !== void 0 ? _request$body : {};
  const replacementsIsValid = typeof replacements === 'object' && Object.keys(replacements).every(key => typeof key === 'string' && typeof replacements[key] === 'string');
  return replacementsIsValid;
};
exports.requestHasRequiredAnonymizationParams = requestHasRequiredAnonymizationParams;