"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsContextService = exports.createMetricsContextService = void 0;
var _dataViewUtils = require("@kbn/data-view-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// metricbeat-*, metrics-*, metric*
const DEFAULT_ALLOWED_METRICS_BASE_PATTERNS = ['metric', 'metrics'];
const DEFAULT_ALLOWED_METRICS_BASE_PATTERNS_REGEXP = (0, _dataViewUtils.createRegExpPatternFrom)(DEFAULT_ALLOWED_METRICS_BASE_PATTERNS, 'data');
const createMetricsContextService = async ({
  metricsExperience
}) => {
  if (!metricsExperience) {
    return getMetricsContextService({
      metricsExperienceClient: undefined
    });
  }
  return getMetricsContextService({
    metricsExperienceClient: metricsExperience.metricsExperienceClient
  });
};
exports.createMetricsContextService = createMetricsContextService;
const getMetricsContextService = ({
  metricsExperienceClient
}) => {
  return {
    getMetricsExperienceClient: () => metricsExperienceClient,
    isMetricsIndexPattern: (0, _dataViewUtils.testPatternAgainstAllowedList)([DEFAULT_ALLOWED_METRICS_BASE_PATTERNS_REGEXP])
  };
};
exports.getMetricsContextService = getMetricsContextService;