"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmErrorsContextService = exports.createApmErrorsContextService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createApmErrorsContextService = async ({
  apmSourcesAccess
}) => {
  if (!apmSourcesAccess) {
    return defaultApmErrorsContextService;
  }
  try {
    const indices = await apmSourcesAccess.getApmIndices();
    if (!indices) {
      return defaultApmErrorsContextService;
    }
    const {
      error
    } = indices;
    return getApmErrorsContextService(error);
  } catch (error) {
    return defaultApmErrorsContextService;
  }
};
exports.createApmErrorsContextService = createApmErrorsContextService;
const getApmErrorsContextService = error => ({
  getErrorsIndexPattern: () => error
});
exports.getApmErrorsContextService = getApmErrorsContextService;
const defaultApmErrorsContextService = getApmErrorsContextService(undefined);