"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchEmbeddableFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _cellActions = require("@kbn/cell-actions");
var _public = require("@kbn/data-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("@kbn/saved-search-plugin/common");
var _presentationContainers = require("@kbn/presentation-containers");
var _get_valid_view_mode = require("../application/main/utils/get_valid_view_mode");
var _search_embeddable_field_stats_table_component = require("./components/search_embeddable_field_stats_table_component");
var _search_embeddable_grid_component = require("./components/search_embeddable_grid_component");
var _initialize_edit_api = require("./initialize_edit_api");
var _initialize_fetch = require("./initialize_fetch");
var _initialize_search_embeddable_api = require("./initialize_search_embeddable_api");
var _serialization_utils = require("./utils/serialization_utils");
var _context_awareness = require("../context_awareness");
var _scoped_services_provider = require("../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/embeddable/get_search_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSearchEmbeddableFactory = ({
  startServices,
  discoverServices
}) => {
  const {
    save,
    checkForDuplicateTitle
  } = discoverServices.savedSearch;
  const savedSearchEmbeddableFactory = {
    type: _discoverUtils.SEARCH_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      parentApi,
      uuid
    }) => {
      var _runtimeState$nonPers, _runtimeState$nonPers2, _getRenderAppWrapper, _discoverServices$emb;
      const runtimeState = await (0, _serialization_utils.deserializeState)({
        serializedState: initialState,
        discoverServices
      });

      /** One Discover context awareness */
      const solutionNavId = (_runtimeState$nonPers = (_runtimeState$nonPers2 = runtimeState.nonPersistedDisplayOptions) === null || _runtimeState$nonPers2 === void 0 ? void 0 : _runtimeState$nonPers2.solutionNavIdOverride) !== null && _runtimeState$nonPers !== void 0 ? _runtimeState$nonPers : await (0, _rxjs.firstValueFrom)(discoverServices.core.chrome.getActiveSolutionNavId$());
      const {
        getRenderAppWrapper
      } = await discoverServices.profilesManager.resolveRootProfile({
        solutionNavId
      });
      const AppWrapper = (_getRenderAppWrapper = getRenderAppWrapper === null || getRenderAppWrapper === void 0 ? void 0 : getRenderAppWrapper(_context_awareness.BaseAppWrapper)) !== null && _getRenderAppWrapper !== void 0 ? _getRenderAppWrapper : _context_awareness.BaseAppWrapper;
      const scopedEbtManager = discoverServices.ebtManager.createScopedEBTManager();
      const scopedProfilesManager = discoverServices.profilesManager.createScopedProfilesManager({
        scopedEbtManager
      });

      /** Specific by-reference state */
      const savedObjectId$ = new _rxjs.BehaviorSubject(runtimeState === null || runtimeState === void 0 ? void 0 : runtimeState.savedObjectId);
      const defaultTitle$ = new _rxjs.BehaviorSubject(runtimeState === null || runtimeState === void 0 ? void 0 : runtimeState.savedObjectTitle);
      const defaultDescription$ = new _rxjs.BehaviorSubject(runtimeState === null || runtimeState === void 0 ? void 0 : runtimeState.savedObjectDescription);

      /** All other state */
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const fetchContext$ = new _rxjs.BehaviorSubject(undefined);
      const fetchWarnings$ = new _rxjs.BehaviorSubject([]);

      /** Build API */
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const dynamicActionsManager = (_discoverServices$emb = discoverServices.embeddableEnhanced) === null || _discoverServices$emb === void 0 ? void 0 : _discoverServices$emb.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
      const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
      const searchEmbeddable = await (0, _initialize_search_embeddable_api.initializeSearchEmbeddableApi)(runtimeState, {
        discoverServices
      });
      const unsubscribeFromFetch = (0, _initialize_fetch.initializeFetch)({
        api: {
          parentApi,
          ...titleManager.api,
          ...timeRangeManager.api,
          defaultTitle$,
          savedSearch$: searchEmbeddable.api.savedSearch$,
          dataViews$: searchEmbeddable.api.dataViews$,
          savedObjectId$,
          dataLoading$,
          blockingError$,
          fetchContext$,
          fetchWarnings$
        },
        discoverServices,
        stateManager: searchEmbeddable.stateManager,
        scopedProfilesManager,
        setDataLoading: dataLoading => dataLoading$.next(dataLoading),
        setBlockingError: error => blockingError$.next(error)
      });
      const serialize = savedObjectId => (0, _serialization_utils.serializeState)({
        uuid,
        initialState: runtimeState,
        savedSearch: searchEmbeddable.api.savedSearch$.getValue(),
        serializeTitles: titleManager.getLatestState,
        serializeTimeRange: timeRangeManager.getLatestState,
        serializeDynamicActions: dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.serializeState,
        savedObjectId
      });
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState: () => serialize(savedObjectId$.getValue()),
        anyStateChange$: (0, _rxjs.merge)(...(dynamicActionsManager ? [dynamicActionsManager.anyStateChange$] : []), searchEmbeddable.anyStateChange$, titleManager.anyStateChange$, timeRangeManager.anyStateChange$),
        getComparators: () => {
          var _dynamicActionsManage;
          return {
            ...((_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {
              enhancements: 'skip'
            }),
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ...searchEmbeddable.comparators,
            attributes: 'skip',
            breakdownField: 'skip',
            hideAggregatedPreview: 'skip',
            hideChart: 'skip',
            isTextBasedQuery: 'skip',
            kibanaSavedObjectMeta: 'skip',
            nonPersistedDisplayOptions: 'skip',
            refreshInterval: 'skip',
            savedObjectId: 'skip',
            timeRestore: 'skip',
            usesAdHocDataView: 'skip',
            controlGroupJson: 'skip',
            visContext: 'skip',
            tabs: 'skip'
          };
        },
        onReset: async lastSaved => {
          var _lastSaved$rawState;
          dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) {
            const lastSavedRuntimeState = await (0, _serialization_utils.deserializeState)({
              serializedState: lastSaved,
              discoverServices
            });
            searchEmbeddable.reinitializeState(lastSavedRuntimeState);
          }
        }
      });
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...titleManager.api,
        ...searchEmbeddable.api,
        ...timeRangeManager.api,
        ...(dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api),
        ...(0, _initialize_edit_api.initializeEditApi)({
          uuid,
          parentApi,
          partialApi: {
            ...searchEmbeddable.api,
            fetchContext$,
            savedObjectId$
          },
          discoverServices,
          isEditable: startServices.isEditable
        }),
        dataLoading$,
        blockingError$,
        savedObjectId$,
        defaultTitle$,
        defaultDescription$,
        hasTimeRange: () => {
          const fetchContext = fetchContext$.getValue();
          return (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeslice) !== undefined || (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeRange) !== undefined;
        },
        getTypeDisplayName: () => _i18n.i18n.translate('discover.embeddable.search.displayName', {
          defaultMessage: 'Discover session'
        }),
        canLinkToLibrary: async () => {
          return discoverServices.capabilities.discover_v2.save && !Boolean(savedObjectId$.getValue());
        },
        canUnlinkFromLibrary: async () => Boolean(savedObjectId$.getValue()),
        saveToLibrary: async title => {
          const savedObjectId = await save({
            ...api.savedSearch$.getValue(),
            title
          });
          defaultTitle$.next(title);
          return savedObjectId;
        },
        checkForDuplicateTitle: (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => checkForDuplicateTitle({
          newTitle,
          isTitleDuplicateConfirmed,
          onTitleDuplicate
        }),
        getSerializedStateByValue: () => serialize(undefined),
        getSerializedStateByReference: newId => serialize(newId),
        serializeState: () => serialize(savedObjectId$.getValue()),
        getInspectorAdapters: () => searchEmbeddable.stateManager.inspectorAdapters.getValue(),
        supportedTriggers: () => {
          // No triggers are supported, but this is still required to pass the drilldown
          // compatibilty check and ensure top-level drilldowns (e.g. URL) work as expected
          return [];
        }
      });
      return {
        api,
        Component: () => {
          var _runtimeState$nonPers3, _runtimeState$nonPers4, _runtimeState$nonPers5;
          const [savedSearch, dataViews] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.savedSearch$, api.dataViews$);
          (0, _react.useEffect)(() => {
            return () => {
              searchEmbeddable.cleanup();
              unsubscribeFromFetch();
              maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
            };
          }, []);
          const viewMode = (0, _react.useMemo)(() => {
            if (!savedSearch.searchSource) return;
            return (0, _get_valid_view_mode.getValidViewMode)({
              viewMode: savedSearch.viewMode,
              isEsqlMode: (0, _initialize_fetch.isEsqlMode)(savedSearch)
            });
          }, [savedSearch]);
          const dataView = (0, _react.useMemo)(() => {
            const hasDataView = (dataViews !== null && dataViews !== void 0 ? dataViews : []).length > 0;
            if (!hasDataView) {
              var _runtimeState$seriali, _runtimeState$seriali2, _runtimeState$seriali3, _runtimeState$seriali4;
              blockingError$.next(new Error(_i18n.i18n.translate('discover.embeddable.search.dataViewError', {
                defaultMessage: 'Missing data view {indexPatternId}',
                values: {
                  indexPatternId: typeof ((_runtimeState$seriali = runtimeState.serializedSearchSource) === null || _runtimeState$seriali === void 0 ? void 0 : _runtimeState$seriali.index) === 'string' ? runtimeState.serializedSearchSource.index : (_runtimeState$seriali2 = (_runtimeState$seriali3 = runtimeState.serializedSearchSource) === null || _runtimeState$seriali3 === void 0 ? void 0 : (_runtimeState$seriali4 = _runtimeState$seriali3.index) === null || _runtimeState$seriali4 === void 0 ? void 0 : _runtimeState$seriali4.id) !== null && _runtimeState$seriali2 !== void 0 ? _runtimeState$seriali2 : ''
                }
              })));
              return;
            }
            return dataViews[0];
          }, [dataViews]);
          const onAddFilter = (0, _react.useCallback)(async (field, value, operator) => {
            if (!dataView || !field) return;
            let newFilters = (0, _public.generateFilters)(discoverServices.filterManager, field, value, operator, dataView);
            newFilters = newFilters.map(filter => ({
              ...filter,
              $state: {
                store: _esQuery.FilterStateStore.APP_STATE
              }
            }));
            await startServices.executeTriggerActions(_public.APPLY_FILTER_TRIGGER, {
              embeddable: api,
              filters: newFilters
            });
          }, [dataView]);
          const renderAsFieldStatsTable = (0, _react.useMemo)(() => Boolean(discoverServices.uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) && viewMode === _common.VIEW_MODE.AGGREGATED_LEVEL && Boolean(dataView) && Array.isArray(savedSearch.columns), [savedSearch, dataView, viewMode]);
          return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, discoverServices.core, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 322,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
            services: discoverServices,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 323,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
            scopedProfilesManager: scopedProfilesManager,
            scopedEBTManager: scopedEbtManager,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 324,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(AppWrapper, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 328,
              columnNumber: 19
            }
          }, renderAsFieldStatsTable ? /*#__PURE__*/_react.default.createElement(_search_embeddable_field_stats_table_component.SearchEmbeddablFieldStatsTableComponent, {
            api: {
              ...api,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) ? undefined : onAddFilter,
            stateManager: searchEmbeddable.stateManager,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 330,
              columnNumber: 23
            }
          }) : /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
            getTriggerCompatibleActions: discoverServices.uiActions.getTriggerCompatibleActions,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 340,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_search_embeddable_grid_component.SearchEmbeddableGridComponent, {
            api: {
              ...api,
              fetchWarnings$,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) || ((_runtimeState$nonPers3 = runtimeState.nonPersistedDisplayOptions) === null || _runtimeState$nonPers3 === void 0 ? void 0 : _runtimeState$nonPers3.enableFilters) === false ? undefined : onAddFilter,
            enableDocumentViewer: ((_runtimeState$nonPers4 = runtimeState.nonPersistedDisplayOptions) === null || _runtimeState$nonPers4 === void 0 ? void 0 : _runtimeState$nonPers4.enableDocumentViewer) !== undefined ? (_runtimeState$nonPers5 = runtimeState.nonPersistedDisplayOptions) === null || _runtimeState$nonPers5 === void 0 ? void 0 : _runtimeState$nonPers5.enableDocumentViewer : true,
            stateManager: searchEmbeddable.stateManager,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 345,
              columnNumber: 25
            }
          }))))));
        }
      };
    }
  };
  return savedSearchEmbeddableFactory;
};
exports.getSearchEmbeddableFactory = getSearchEmbeddableFactory;