"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _has_any_field_with_prefixes = require("../../utils/has_any_field_with_prefixes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/observability_root_profile/accessors/get_doc_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const attributesPrefixes = ['attributes.', 'scope.attributes.', 'resource.attributes.'];
const hasAnyAttributesField = (0, _has_any_field_with_prefixes.hasAnyFieldWithPrefixes)(attributesPrefixes);
const getDocViewer = prev => params => {
  const prevDocViewer = prev(params);
  const tabTitle = _i18n.i18n.translate('discover.docViews.observability.attributesOverview.title', {
    defaultMessage: 'Attributes'
  });
  return {
    ...prevDocViewer,
    docViewsRegistry: registry => {
      if (hasAnyAttributesField(params.record)) {
        registry.add({
          id: 'doc_view_obs_attributes_overview',
          title: tabTitle,
          order: 9,
          component: props => {
            return /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerObservabilityAttributesOverview, (0, _extends2.default)({}, props, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 35,
                columnNumber: 22
              }
            }));
          }
        });
      }
      return prevDocViewer.docViewsRegistry(registry);
    }
  };
};
exports.getDocViewer = getDocViewer;