"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSessionSaveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/save_discover_session/save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverSessionSaveModal = ({
  isTimeBased,
  services: {
    savedObjectsTagging,
    discoverFeatureFlags
  },
  title,
  description,
  tags,
  showCopyOnSave,
  initialCopyOnSave,
  timeRestore: savedTimeRestore,
  onSave,
  onClose,
  managed
}) => {
  const [timeRestore, setTimeRestore] = (0, _react.useState)(Boolean(isTimeBased && savedTimeRestore));
  const [currentTags, setCurrentTags] = (0, _react.useState)(tags);
  const tabsEnabled = discoverFeatureFlags.getTabsEnabled();
  const onModalSave = async params => {
    await onSave({
      ...params,
      newTimeRestore: timeRestore,
      newTags: currentTags
    });
  };
  const tagSelector = savedObjectsTagging ? /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
    initialSelection: currentTags,
    onTagsSelected: newTags => {
      setCurrentTags(newTags);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }) : null;
  const timeSwitch = isTimeBased ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.topNav.saveModal.storeTimeWithSearchToggleDescription",
      defaultMessage: "Update the time filter and refresh interval to the current selection when using this session.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "storeTimeWithSearch",
    checked: timeRestore,
    onChange: event => setTimeRestore(event.target.checked),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.topNav.saveModal.storeTimeWithSearchToggleLabel",
      defaultMessage: "Store time with Discover session",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  })) : null;
  const options = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tagSelector, timeSwitch);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    customModalTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.localMenu.saveModalTitle",
      defaultMessage: "Save Discover session",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }), tabsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('discover.localMenu.saveModalSubtitle', {
      defaultMessage: 'All open tabs will be saved to this session'
    })))),
    title: title,
    showCopyOnSave: showCopyOnSave,
    initialCopyOnSave: initialCopyOnSave,
    description: description,
    objectType: _i18n.i18n.translate('discover.localMenu.saveSaveSearchObjectType', {
      defaultMessage: 'Discover session'
    }),
    showDescription: true,
    options: options,
    onSave: onModalSave,
    onClose: onClose,
    mustCopyOnSaveMessage: managed ? _i18n.i18n.translate('discover.localMenu.mustCopyOnSave', {
      defaultMessage: 'Elastic manages this Discover session. Save any changes to a new Discover session.'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
exports.DiscoverSessionSaveModal = DiscoverSessionSaveModal;