"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _unifiedTabs = require("@kbn/unified-tabs");
var _single_tab_view = require("../single_tab_view");
var _redux = require("../../state_management/redux");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _use_preview_data = require("./use_preview_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/tabs_view/tabs_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_TABS_COUNT = 25;
const TabsView = props => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const items = (0, _redux.useInternalStateSelector)(_redux.selectAllTabs);
  const recentlyClosedItems = (0, _redux.useInternalStateSelector)(_redux.selectRecentlyClosedTabs);
  const currentTabId = (0, _redux.useInternalStateSelector)(state => state.tabs.unsafeCurrentId);
  const {
    getPreviewData
  } = (0, _use_preview_data.usePreviewData)(props.runtimeStateManager);
  const hideTabsBar = (0, _redux.useInternalStateSelector)(_redux.selectIsTabsBarHidden);
  const unsavedTabIds = (0, _redux.useInternalStateSelector)(state => state.tabs.unsavedIds);
  const scopedEbtManager = (0, _redux.useCurrentTabRuntimeState)(props.runtimeStateManager, state => state.scopedEbtManager$);
  const onEvent = (0, _react.useCallback)(event => {
    void scopedEbtManager.trackTabsEvent(event);
  }, [scopedEbtManager]);
  const onChanged = (0, _react.useCallback)(updateState => dispatch(_redux.internalStateActions.updateTabs(updateState)), [dispatch]);
  const onClearRecentlyClosed = (0, _react.useCallback)(() => dispatch(_redux.internalStateActions.clearRecentlyClosedTabs()), [dispatch]);
  const createItem = (0, _react.useCallback)(() => (0, _redux.createTabItem)(items), [items]);
  const renderContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_single_tab_view.SingleTabView, (0, _extends2.default)({
    key: currentTabId
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })), [currentTabId, props]);
  return /*#__PURE__*/_react.default.createElement(_unifiedTabs.UnifiedTabs, {
    services: services,
    items: items,
    selectedItemId: currentTabId,
    recentlyClosedItems: recentlyClosedItems,
    unsavedItemIds: unsavedTabIds,
    maxItemsCount: MAX_TABS_COUNT,
    hideTabsBar: hideTabsBar,
    createItem: createItem,
    getPreviewData: getPreviewData,
    renderContent: renderContent,
    onChanged: onChanged,
    onEBTEvent: onEvent,
    onClearRecentlyClosed: onClearRecentlyClosed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  });
};
exports.TabsView = TabsView;