"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrandedLoadingIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _loading_indicator = require("../../../../components/common/loading_indicator");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/single_tab_view/branded_loading_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const BrandedLoadingIndicator = () => {
  const {
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const hasCustomBranding = (0, _useObservable.default)(core.customBranding.hasCustomBranding$, false);
  return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    type: hasCustomBranding ? 'spinner' : 'elastic',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 10
    }
  });
};
exports.BrandedLoadingIndicator = BrandedLoadingIndicator;