"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleDocRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _loading_indicator = require("../../components/common/loading_indicator");
var _doc = require("./components/doc");
var _use_discover_services = require("../../hooks/use_discover_services");
var _error_alert = require("../../components/common/error_alert");
var _use_data_view = require("../../hooks/use_data_view");
var _context_awareness = require("../../context_awareness");
var _scoped_services_provider = require("../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/doc/single_doc_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SingleDocRoute = () => {
  const {
    timefilter,
    core,
    profilesManager,
    ebtManager,
    getScopedHistory
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    dataViewId,
    index
  } = (0, _reactRouterDom.useParams)();
  const query = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const id = query.get('id');
  const locationState = (0, _react.useMemo)(() => {
    var _getScopedHistory;
    return (_getScopedHistory = getScopedHistory()) === null || _getScopedHistory === void 0 ? void 0 : _getScopedHistory.location.state;
  }, [getScopedHistory]);
  (0, _public.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'single-doc',
    id: dataViewId
  });
  (0, _react.useEffect)(() => {
    timefilter.disableAutoRefreshSelector();
    timefilter.disableTimeRangeSelector();
  }, [timefilter]);
  const {
    dataView,
    error
  } = (0, _use_data_view.useDataView)({
    index: (locationState === null || locationState === void 0 ? void 0 : locationState.dataViewSpec) || decodeURIComponent(dataViewId)
  });
  const [scopedEbtManager] = (0, _react.useState)(() => ebtManager.createScopedEBTManager());
  const [scopedProfilesManager] = (0, _react.useState)(() => profilesManager.createScopedProfilesManager({
    scopedEbtManager
  }));
  const rootProfileState = (0, _context_awareness.useRootProfile)();
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.singleDocRoute.errorTitle",
        defaultMessage: "An error occurred",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 11
        }
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.singleDocRoute.errorMessage",
        defaultMessage: "No matching data view for id {dataViewId}",
        values: {
          dataViewId
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    });
  }
  if (!dataView || rootProfileState.rootProfileLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 12
      }
    });
  }
  if (!id) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: new Error(_i18n.i18n.translate('discover.discoverError.missingIdParamError', {
        defaultMessage: 'No document ID provided. Return to Discover to select another document.'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: scopedProfilesManager,
    scopedEBTManager: scopedEbtManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(rootProfileState.AppWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_doc.Doc, {
    id: id,
    index: index,
    dataView: dataView,
    referrer: locationState === null || locationState === void 0 ? void 0 : locationState.referrer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })));
};
exports.SingleDocRoute = SingleDocRoute;