"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailureStoreWarning = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/failure_store/failure_store_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FailureStoreWarning = () => {
  const {
    services
  } = (0, _utils.useKibanaContextForPlugin)();
  const noAccessToFailureStoreWarningDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.noAccessToFailureStore.description",
    defaultMessage: "{description}",
    values: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.datasetQuality.noAccessToFailureStore.warning",
        defaultMessage: "Documents that fail to be ingested are sent to the failure store. You don't have the required privileges to access failure stores. Contact your administrator. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            external: true,
            target: "_blank",
            "data-test-subj": "datasetQualityNoAccessToFailureStoreLink",
            href: services.docLinks.links.datasetQuality.failureStore,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 28,
              columnNumber: 17
            }
          }, _i18n.i18n.translate('xpack.datasetQuality.noAccessToFailureStore.link.title', {
            defaultMessage: 'Learn more'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 11
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: noAccessToFailureStoreWarningDescription,
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
};
exports.FailureStoreWarning = FailureStoreWarning;