"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Header;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../../common/translations");
var _alert_flyout = require("../../alerts/alert_flyout");
var _get_alerting_capabilities = require("../../alerts/get_alerting_capabilities");
var _utils = require("../../utils");
var _constants = require("../../../common/constants");
var _use_dataset_quality_filters = require("../../hooks/use_dataset_quality_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Header() {
  const {
    services: {
      application,
      alerting
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    capabilities
  } = application;
  const [ruleType, setRuleType] = (0, _react.useState)(null);
  const {
    isAlertingAvailable
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(alerting, capabilities);
  const {
    isDatasetQualityAllSignalsAvailable,
    authorizedDatasetTypes
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const validTypes = (0, _react.useMemo)(() => isDatasetQualityAllSignalsAvailable ? authorizedDatasetTypes : [_constants.DEFAULT_DATASET_TYPE], [isDatasetQualityAllSignalsAvailable, authorizedDatasetTypes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.datasetQualityAppTitle, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: betaBadgeLabel,
      title: betaBadgeLabel,
      tooltipContent: betaBadgeDescription,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.appDescription",
      defaultMessage: "Monitor the data set quality for {types} data streams that follow the {dsNamingSchemeLink}.",
      values: {
        types: validTypes.map((type, index) => {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index > 0 && ', ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 61,
              columnNumber: 19
            }
          }, type));
        }),
        dsNamingSchemeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "datasetQualityAppDescriptionDsNamingSchemeLink",
          href: "https://ela.st/data-stream-naming-scheme",
          target: "_blank",
          rel: "noopener",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.appDescription.dsNamingSchemeLinkText",
          defaultMessage: "Data stream naming scheme",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 17
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    rightSideItems: isAlertingAvailable && validTypes.length ? [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "datasetQualityDetailsHeaderButton",
      onClick: () => {
        setRuleType(_ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID);
      },
      iconType: "bell",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 17
      }
    }, _translations.createAlertText), ruleType === _ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
      closeFlyout: () => setRuleType(null),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 19
      }
    }))] : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  });
}
const betaBadgeLabel = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeLabel', {
  defaultMessage: 'Beta'
});
const betaBadgeDescription = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeDescription', {
  defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, we’d love to hear from you. Please open a support issue and/or visit our discussion forum.'
});
module.exports = exports.default;