"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFlyout = createFlyout;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/flyout/create_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function createFlyout(coreStart, plugins, props) {
  const {
    http,
    overlays,
    application: {
      currentAppId$
    },
    ...startServices
  } = coreStart;
  const LazyFlyoutContents = /*#__PURE__*/(0, _react.lazy)(async () => {
    const {
      FileDataVisualizerLite
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../file_upload_lite')));
    return {
      default: FileDataVisualizerLite
    };
  });
  let results = null;
  const onFlyoutClose = () => {
    flyoutSession.close();
    if (results !== null && typeof props.onUploadComplete === 'function') {
      props.onUploadComplete(results);
    }
  };
  const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(LoadingContents, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 27
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(LazyFlyoutContents, {
    coreStart: coreStart,
    plugins: plugins,
    props: {
      ...props,
      onUploadComplete: res => {
        if (res) {
          results = res;
        }
      }
    },
    onClose: onFlyoutClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), startServices), {
    'data-test-subj': 'mlFlyoutLayerSelector',
    ownFocus: true,
    onClose: onFlyoutClose,
    size: '500px'
  });

  // Close the flyout when user navigates out of the current plugin
  currentAppId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _rxjs.distinctUntilChanged)()).subscribe(() => {
    flyoutSession.close();
  });
}
const LoadingContents = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.dataVisualizer.file.uploadView.uploadFileTitle",
  defaultMessage: "Upload a file",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 11
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 5
  }
}));