"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftDetectionAppState = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_state_manager = require("./use_state_manager");
var _storage = require("../index_data_visualizer/types/storage");
var _kibana_services = require("../../kibana_services");
var _data_drift_page = require("./data_drift_page");
var _data_source_context = require("../common/hooks/data_source_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/data_drift_app_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const localStorage = new _public.Storage(window.localStorage);
const getStr = (arg, fallbackStr) => {
  if (arg === undefined || arg == null) return fallbackStr !== null && fallbackStr !== void 0 ? fallbackStr : '';
  if (typeof arg === 'string') return arg.replaceAll(`'`, '');
  if (Array.isArray(arg)) return arg.join(',');
  return '';
};
const DataDriftDetectionAppState = ({
  dataView,
  savedSearch
}) => {
  var _dataView$getTimeFiel, _getStr, _getStr2;
  if (!(dataView || savedSearch)) {
    throw Error('No data view or saved search available.');
  }
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  };
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme', 'userProfile');
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'i18n', 'theme', 'userProfile', 'uiSettings']),
    uiSettingsKeys: _common.UI_SETTINGS
  };
  const location = (0, _reactRouterDom.useLocation)();
  const params = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const initialSettings = {
    index: getStr(params.index, dataView.id),
    comparison: getStr(params.comparison, dataView.getIndexPattern()),
    reference: getStr(params.reference, dataView.getIndexPattern()),
    timeField: getStr(params.timeField, (_dataView$getTimeFiel = dataView.getTimeField()) === null || _dataView$getTimeFiel === void 0 ? void 0 : _dataView$getTimeFiel.name)
  };
  const referenceStateManager = (0, _use_state_manager.useDataDriftStateManager)({
    id: 'referenceDataDriftData',
    indexPattern: (_getStr = getStr(params.reference)) !== null && _getStr !== void 0 ? _getStr : dataView.getIndexPattern(),
    searchString: '',
    searchQuery: _use_state_manager.defaultSearchQuery,
    searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
    filters: [],
    timeField: dataView.timeFieldName
  });
  const comparisonStateManager = (0, _use_state_manager.useDataDriftStateManager)({
    id: 'comparisonDataDriftData',
    indexPattern: (_getStr2 = getStr(params.comparison)) !== null && _getStr2 !== void 0 ? _getStr2 : dataView.getIndexPattern(),
    searchString: '',
    searchQuery: _use_state_manager.defaultSearchQuery,
    searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
    filters: [],
    timeField: dataView.timeFieldName
  });
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...services
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_source_context.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.DV_STORAGE_KEYS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_use_state_manager.DataDriftStateManagerContext.Provider, {
    value: {
      dataView,
      reference: referenceStateManager,
      comparison: comparisonStateManager
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_data_drift_page.DataDriftPage, {
    initialSettings: initialSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 19
    }
  }))))))));
};
exports.DataDriftDetectionAppState = DataDriftDetectionAppState;