"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldCountPanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _field_count_stats = require("../stats_table/components/field_count_stats");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/field_count_panel/field_count_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldCountPanel = ({
  metricsStats,
  fieldsCountStats,
  showEmptyFields,
  toggleShowEmptyFields
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dvFieldCountPanelCss = (0, _react2.css)({
    marginLeft: euiTheme.size.xs,
    [(0, _eui.useEuiBreakpoint)(['xs', 's'])]: {
      flexDirection: 'column',
      alignItems: 'flex-start'
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    css: dvFieldCountPanelCss,
    "data-test-subj": "dataVisualizerFieldCountPanel",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_count_stats.TotalFieldsCount, {
    fieldsCountStats: fieldsCountStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_field_count_stats.MetricFieldsCount, {
    metricsStats: metricsStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _field_count_stats.dvFieldCountItemCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "dataVisualizerShowEmptyFieldsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.searchPanel.showEmptyFields",
      defaultMessage: "Show empty fields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }),
    checked: showEmptyFields,
    onChange: toggleShowEmptyFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })));
};
exports.FieldCountPanel = FieldCountPanel;