"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexBasedDataVisualizerExpandedRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_expanded_row_css = require("./use_expanded_row_css");
var _geo_point_content_with_map = require("./geo_point_content_with_map");
var _constants = require("../../../../../common/constants");
var _field_data_expanded_row = require("../stats_table/components/field_data_expanded_row");
var _not_in_docs_content = require("../not_in_docs_content");
var _loading_indicator = require("../loading_indicator");
var _error_message = require("../stats_table/components/field_data_expanded_row/error_message");
var _not_supported_content = require("../not_in_docs_content/not_supported_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/expanded_row/index_based_expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexBasedDataVisualizerExpandedRow = ({
  item,
  dataView,
  combinedQuery,
  onAddFilter,
  esql,
  totalDocuments,
  timeFieldName,
  typeAccessor = 'type',
  onVisibilityChange
}) => {
  const config = {
    ...item,
    stats: {
      ...item.stats,
      totalDocuments
    }
  };
  const {
    loading,
    existsInDocs,
    fieldName
  } = config;
  const type = config[typeAccessor];
  const dvExpandedRow = (0, _use_expanded_row_css.useExpandedRowCss)();
  function getCardContent() {
    var _item$secondaryType, _config$stats;
    if (type === 'unknown' || type.includes('vector') || (_item$secondaryType = item.secondaryType) !== null && _item$secondaryType !== void 0 && _item$secondaryType.includes('vector')) {
      return /*#__PURE__*/_react.default.createElement(_not_supported_content.NotSupportedContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 14
        }
      });
    }
    if (existsInDocs === false) {
      return /*#__PURE__*/_react.default.createElement(_not_in_docs_content.NotInDocsContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 14
        }
      });
    }
    if ((_config$stats = config.stats) !== null && _config$stats !== void 0 && _config$stats.error) {
      var _config$stats2;
      return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessageContent, {
        fieldName: fieldName,
        error: (_config$stats2 = config.stats) === null || _config$stats2 === void 0 ? void 0 : _config$stats2.error,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 14
        }
      });
    }
    switch (type) {
      case _constants.SUPPORTED_FIELD_TYPES.NUMBER:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.NumberContent, {
          config: config,
          onAddFilter: onAddFilter,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.BOOLEAN:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.BooleanContent, {
          config: config,
          onAddFilter: onAddFilter,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.DATE:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.DateContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.GEO_POINT:
      case _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE:
        return /*#__PURE__*/_react.default.createElement(_geo_point_content_with_map.GeoPointContentWithMap, {
          config: config,
          dataView: dataView,
          combinedQuery: combinedQuery,
          esql: esql,
          timeFieldName: timeFieldName,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 11
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.IP:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.IpContent, {
          config: config,
          onAddFilter: onAddFilter,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 94,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.KEYWORD:
      case _constants.SUPPORTED_FIELD_TYPES.VERSION:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.KeywordContent, {
          config: config,
          onAddFilter: onAddFilter,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.TEXT:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.TextContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 16
          }
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.OtherContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 16
          }
        });
    }
  }
  (0, _react.useEffect)(() => {
    onVisibilityChange === null || onVisibilityChange === void 0 ? void 0 : onVisibilityChange(true, item);
    return () => {
      onVisibilityChange === null || onVisibilityChange === void 0 ? void 0 : onVisibilityChange(false, item);
    };
  }, [item, onVisibilityChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: dvExpandedRow,
    "data-test-subj": `dataVisualizerFieldExpandedRow-${fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, loading === true ? /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 27
    }
  }) : getCardContent());
};
exports.IndexBasedDataVisualizerExpandedRow = IndexBasedDataVisualizerExpandedRow;