"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _random_sampler = require("../../../index_data_visualizer/constants/random_sampler");
var _total_count_header = require("./total_count_header");
var _document_count_chart = require("./document_count_chart");
var _random_sampler_range_slider = require("../random_sampling_menu/random_sampler_range_slider");
var _probability_used = require("../random_sampling_menu/probability_used");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/document_count_content/document_count_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CalculatingProbabilityMessage = /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "dvRandomSamplerCalculatingProbabilityMsg",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.dataVisualizer.randomSamplerSettingsPopUp.calculatingProbabilityLabel",
  defaultMessage: "Calculating the optimal probability",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
const DocumentCountContent = ({
  documentCountStats,
  totalCount,
  samplingProbability,
  setSamplingProbability,
  loading,
  randomSamplerPreference,
  setRandomSamplerPreference,
  showSettings = true
}) => {
  const [showSamplingOptionsPopover, setShowSamplingOptionsPopover] = (0, _react.useState)(false);
  const onShowSamplingOptions = (0, _react.useCallback)(() => {
    setShowSamplingOptionsPopover(!showSamplingOptionsPopover);
  }, [showSamplingOptionsPopover]);
  const closeSamplingOptions = (0, _react.useCallback)(() => {
    setShowSamplingOptionsPopover(false);
  }, [setShowSamplingOptionsPopover]);
  const calloutInfoMessage = (0, _react.useMemo)(() => {
    switch (randomSamplerPreference) {
      case _random_sampler.RANDOM_SAMPLER_OPTION.OFF:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.offCalloutMessage', {
          defaultMessage: 'Random sampling can be turned on for the total document count and chart to increase speed although some accuracy will be lost.'
        });
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onAutomaticCalloutMessage', {
          defaultMessage: 'The total document count and chart use random sampler aggregations. The probability is automatically set to balance accuracy and speed.'
        });
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL:
      default:
        return _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onManualCalloutMessage', {
          defaultMessage: 'The total document count and chart use random sampler aggregations. A lower percentage probability increases performance, but some accuracy is lost.'
        });
    }
  }, [randomSamplerPreference]);
  if (documentCountStats === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 39
      }
    }) : null;
  }
  const {
    timeRangeEarliest,
    timeRangeLatest
  } = documentCountStats;
  if (timeRangeEarliest === undefined || timeRangeLatest === undefined) return /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 12
    }
  });
  let chartPoints = [];
  if (documentCountStats.buckets !== undefined) {
    const buckets = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.buckets;
    chartPoints = Object.entries(buckets).map(([time, value]) => ({
      time: +time,
      value
    }));
  }
  const approximate = documentCountStats.randomlySampled === true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    approximate: approximate,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), showSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "dvRandomSamplerOptionsPopover",
    id: "dataVisualizerSamplingOptions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.dataVisualizer.samplingOptionsButton', {
        defaultMessage: 'Sampling options'
      }),
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "xs",
      iconType: "gear",
      onClick: onShowSamplingOptions,
      "data-test-subj": "dvRandomSamplerOptionsButton",
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.samplingOptionsButton', {
        defaultMessage: 'Sampling options'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 19
      }
    })),
    isOpen: showSamplingOptionsPopover,
    closePopover: closeSamplingOptions,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: 'primary',
    title: calloutInfoMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }), setRandomSamplerPreference ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "dvRandomSamplerOptionsFormRow",
    label: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerRowLabel', {
      defaultMessage: 'Random sampling'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "dvRandomSamplerOptionsSelect",
    options: _random_sampler.RANDOM_SAMPLER_SELECT_OPTIONS,
    value: randomSamplerPreference,
    onChange: e => setRandomSamplerPreference(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 21
    }
  })) : null, randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL ? /*#__PURE__*/_react.default.createElement(_random_sampler_range_slider.RandomSamplerRangeSlider, {
    samplingProbability: samplingProbability,
    setSamplingProbability: setSamplingProbability,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 19
    }
  }) : null, randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC ? loading ? CalculatingProbabilityMessage : /*#__PURE__*/_react.default.createElement(_probability_used.ProbabilityUsedMessage, {
    samplingProbability: samplingProbability,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 21
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_document_count_chart.DocumentCountChart, {
    chartPoints: chartPoints,
    timeRangeEarliest: timeRangeEarliest,
    timeRangeLatest: timeRangeLatest,
    interval: documentCountStats.interval,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }));
};
exports.DocumentCountContent = DocumentCountContent;