"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _schemas = require("../../../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dataViewAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  type: _configSchema.schema.maybe(_configSchema.schema.literal(_common.DataViewType.ROLLUP)),
  timeFieldName: _configSchema.schema.maybe(_configSchema.schema.string()),
  sourceFilters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    value: _configSchema.schema.string(),
    clientId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))
  }))),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_schemas.fieldSpecSchema)),
  typeMeta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  fieldFormatMap: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _schemas.serializedFieldFormatSchema)),
  fieldAttrs: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    customLabel: _configSchema.schema.maybe(_configSchema.schema.string()),
    customDescription: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: _constants.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH
    })),
    count: _configSchema.schema.maybe(_configSchema.schema.number())
  }))),
  allowNoIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  runtimeFieldMap: _configSchema.schema.maybe(_configSchema.schema.any()),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  allowHidden: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
});
const dataViewSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(dataViewAttributesSchema);
const dataViewCreateOptionsSchema = _configSchema.schema.object({
  id: _contentManagementUtils.createOptionsSchemas.id,
  initialNamespaces: _contentManagementUtils.createOptionsSchemas.initialNamespaces,
  overwrite: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.overwrite),
  managed: _contentManagementUtils.createOptionsSchemas.managed
});
const dataViewSearchOptionsSchema = _configSchema.schema.object({
  searchFields: _contentManagementUtils.searchOptionsSchemas.searchFields,
  fields: _contentManagementUtils.searchOptionsSchemas.fields
});
const dataViewUpdateOptionsSchema = _configSchema.schema.object({
  version: _contentManagementUtils.updateOptionsSchema.version,
  refresh: _contentManagementUtils.updateOptionsSchema.refresh,
  retryOnConflict: _contentManagementUtils.updateOptionsSchema.retryOnConflict
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(dataViewSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: dataViewCreateOptionsSchema
      },
      data: {
        schema: dataViewAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(dataViewSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: dataViewUpdateOptionsSchema
      },
      data: {
        schema: dataViewAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: dataViewSearchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: dataViewSavedObjectSchema
      }
    }
  }
};