"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDataView = validateDataView;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function dataViewContainsSpaces(indexPattern) {
  return indexPattern.includes(' ');
}
function findIllegalCharacters(indexPattern) {
  const illegalCharacters = _constants.ILLEGAL_CHARACTERS_VISIBLE.reduce((chars, char) => {
    if (indexPattern.includes(char)) {
      chars.push(char);
    }
    return chars;
  }, []);
  return illegalCharacters;
}

/**
 * Validate index pattern strings
 * @public
 * @param indexPattern string to validate
 * @returns errors object
 */

function validateDataView(indexPattern) {
  const errors = {};
  const illegalCharacters = findIllegalCharacters(indexPattern);
  if (illegalCharacters.length) {
    errors[_constants.ILLEGAL_CHARACTERS_KEY] = illegalCharacters;
  }
  if (dataViewContainsSpaces(indexPattern)) {
    errors[_constants.CONTAINS_SPACES_KEY] = true;
  }
  return errors;
}