"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartsFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _rest_types = require("../../../common/rest_types");
var _translations = require("../../translations");
var _use_charts_url_params = require("./use_charts_url_params");
var _format_bytes = require("../../utils/format_bytes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_usage/public/app/hooks/use_charts_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useChartsFilter = ({
  filterOptions
}) => {
  const {
    dataStreams: selectedDataStreamsFromUrl,
    metricTypes: selectedMetricTypesFromUrl,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter
  } = (0, _use_charts_url_params.useDataUsageMetricsUrlParams)();
  const isMetricTypesFilter = filterOptions.filterName === 'metricTypes';
  const isDataStreamsFilter = filterOptions.filterName === 'dataStreams';

  // track the state of selected data streams via URL
  //  when the page is loaded via selected data streams on URL
  const [areDataStreamsSelectedOnMount, setAreDataStreamsSelectedOnMount] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (selectedDataStreamsFromUrl && selectedDataStreamsFromUrl.length > 0) {
      setAreDataStreamsSelectedOnMount(true);
    }
    // don't sync with changes to further selectedDataStreamsFromUrl
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const initialSelectedOptions = (0, _react.useMemo)(() => {
    if (isMetricTypesFilter) {
      return _rest_types.METRIC_TYPE_VALUES.map(metricType => ({
        key: metricType,
        label: _rest_types.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP[metricType],
        checked: selectedMetricTypesFromUrl ? selectedMetricTypesFromUrl.includes(metricType) ? 'on' : undefined : (0, _rest_types.isDefaultMetricType)(metricType) // default metrics are selected by default
        ? 'on' : undefined,
        'data-test-subj': `${filterOptions.filterName}-filter-option`
      }));
    }
    let dataStreamOptions = [];
    if (isDataStreamsFilter && !!filterOptions.options.length) {
      var _filterOptions$option;
      dataStreamOptions = (_filterOptions$option = filterOptions.options) === null || _filterOptions$option === void 0 ? void 0 : _filterOptions$option.map((filterOption, i) => {
        var _filterOptions$append, _filterOptions$append2;
        return {
          key: filterOption,
          label: filterOption,
          append: (0, _format_bytes.formatBytes)((_filterOptions$append = (_filterOptions$append2 = filterOptions.appendOptions) === null || _filterOptions$append2 === void 0 ? void 0 : _filterOptions$append2[filterOption]) !== null && _filterOptions$append !== void 0 ? _filterOptions$append : 0),
          checked: selectedDataStreamsFromUrl ? selectedDataStreamsFromUrl.includes(filterOption) ? 'on' : undefined : i < _common.DEFAULT_SELECTED_OPTIONS ? 'on' : undefined,
          'data-test-subj': `${filterOptions.filterName}-filter-option`,
          truncationProps: {
            truncation: 'start',
            truncationOffset: 15
          }
        };
      });
    }
    return [{
      label: _translations.UX_LABELS.filters.dataStreams.label,
      append: /*#__PURE__*/_react.default.createElement("span", {
        css: {
          display: 'flex',
          alignItems: 'flex-end',
          marginLeft: 'auto'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 11
        }
      }, _translations.UX_LABELS.filters.dataStreams.append, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.UX_LABELS.filters.dataStreams.appendTooltip,
        type: "info",
        color: "subdued",
        css: {
          alignContent: 'flex-start',
          justifyContent: 'flex-start'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 13
        }
      })),
      isGroupLabel: true,
      'data-test-subj': `${filterOptions.filterName}-group-label`
    }, ...dataStreamOptions];
  }, [filterOptions.appendOptions, filterOptions.filterName, filterOptions.options, isDataStreamsFilter, isMetricTypesFilter, selectedDataStreamsFromUrl, selectedMetricTypesFromUrl]);
  // filter options
  const [items, setItems] = (0, _react.useState)(initialSelectedOptions);
  const hasActiveFilters = (0, _react.useMemo)(() => !!items.find(item => !item.isGroupLabel && item.checked === 'on'), [items]);
  const numActiveFilters = (0, _react.useMemo)(() => items.filter(item => !item.isGroupLabel && item.checked === 'on').length, [items]);
  const numFilters = (0, _react.useMemo)(() => items.filter(item => item.key && item.checked !== 'on').length, [items]);
  return {
    areDataStreamsSelectedOnMount,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreDataStreamsSelectedOnMount,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter
  };
};
exports.useChartsFilter = useChartsFilter;