"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectToItem = savedObjectToItem;
var _lodash = require("lodash");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function savedObjectToItem(savedObject, partial, {
  allowedAttributes,
  allowedReferences
} = {}) {
  const {
    id,
    type,
    updated_at: updatedAt,
    updated_by: updatedBy,
    created_at: createdAt,
    created_by: createdBy,
    attributes,
    error,
    namespaces,
    version,
    managed
  } = savedObject;
  try {
    var _savedObject$referenc;
    const dashboardState = (0, _transforms.transformDashboardOut)(attributes, savedObject.references);
    const references = (0, _transforms.transformReferencesOut)((_savedObject$referenc = savedObject.references) !== null && _savedObject$referenc !== void 0 ? _savedObject$referenc : []);
    return {
      item: {
        id,
        type,
        updatedAt,
        updatedBy,
        createdAt,
        createdBy,
        attributes: allowedAttributes ? (0, _lodash.pick)(dashboardState, allowedAttributes) : dashboardState,
        error,
        namespaces,
        references: allowedReferences ? references === null || references === void 0 ? void 0 : references.filter(reference => allowedReferences.includes(reference.type)) : references,
        version,
        managed
      },
      error: null
    };
  } catch (e) {
    return {
      item: null,
      error: e
    };
  }
}