"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditorPreviewSwitch = void 0;
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/dashboard_markdown/public/components/markdown_editor_preview_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const generateId = (0, _eui.htmlIdGenerator)();
const EDITOR_ID = generateId('markdown_editor__editor');
const PREVIEW_ID = generateId('markdown_editor__preview');
const editorPreviewOptions = [{
  id: EDITOR_ID,
  'data-test-subj': 'markdownEditorEditor',
  label: _i18n.i18n.translate('dashboardMarkdown.editor', {
    defaultMessage: 'Editor'
  })
}, {
  id: PREVIEW_ID,
  'data-test-subj': 'markdownEditorPreview',
  label: _i18n.i18n.translate('dashboardMarkdown.preview', {
    defaultMessage: 'Preview'
  })
}];
const switchStyles = {
  buttonGroup: ({
    euiTheme
  }) => ({
    background: 'none',
    padding: 0,
    marginBottom: euiTheme.size.xs,
    '*': {
      border: 'none !important'
    },
    button: {
      marginBottom: 0,
      marginTop: 0
    }
  })
};
const MarkdownEditorPreviewSwitch = ({
  isPreview$,
  isEditing$,
  onSwitch
}) => {
  const [isPreview, isEditing] = (0, _presentationPublishing.useBatchedPublishingSubjects)(isPreview$, isEditing$);
  const styles = (0, _use_memo_css.useMemoCss)(switchStyles);
  if (!isEditing) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('dashboardMarkdown.editorPreviewSwitch', {
      defaultMessage: 'Editor/Preview switch'
    }),
    options: editorPreviewOptions,
    idSelected: isPreview ? PREVIEW_ID : EDITOR_ID,
    onChange: id => {
      onSwitch(id === PREVIEW_ID);
    },
    buttonSize: "compressed",
    type: "single",
    css: styles.buttonGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
};
exports.MarkdownEditorPreviewSwitch = MarkdownEditorPreviewSwitch;