"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIntegrationsPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _common = require("../common");
var _services = require("./services");
var _kibana = require("./services/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/custom_integrations/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CustomIntegrationsPlugin {
  setup(core) {
    // Return methods that should be available to other plugins
    return {
      async getReplacementCustomIntegrations() {
        return core.http.get(_common.ROUTES_REPLACEMENT_CUSTOM_INTEGRATIONS);
      },
      async getAppendCustomIntegrations() {
        return core.http.get(_common.ROUTES_APPEND_CUSTOM_INTEGRATIONS);
      }
    };
  }
  start(coreStart, startPlugins) {
    const services = (0, _kibana.servicesFactory)({
      coreStart,
      startPlugins
    });
    const languageClientsUiComponents = {
      sample: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).SampleClientReadme
      })),
      javascript: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchJsClientReadme
      })),
      python: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchPyClientReadme
      })),
      go: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchGoClientReadme
      })),
      ruby: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchRubyClientReadme
      })),
      java: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchJavaClientReadme
      })),
      php: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchPhpClientReadme
      })),
      dotnet: /*#__PURE__*/_react.default.lazy(async () => ({
        default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./language_components')))).ElasticsearchDotnetClientReadme
      }))
    };
    const ContextProvider = ({
      children
    }) => /*#__PURE__*/_react.default.createElement(_services.CustomIntegrationsServicesProvider, (0, _extends2.default)({}, services, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }), children);
    return {
      ContextProvider,
      languageClientsUiComponents
    };
  }
  stop() {}
}
exports.CustomIntegrationsPlugin = CustomIntegrationsPlugin;