"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTopBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react2 = require("@emotion/react");
var _header_extension = require("./header_extension");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_top_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const styles = {
  root: {
    fixed: (0, _react2.css)`
      position: fixed;
      top: 0;
      left: 0;
      height: var(--kbnHeaderBannerHeight);
      width: 100%;
    `,
    static: (0, _react2.css)`
      height: var(--kbnHeaderBannerHeight);
      width: 100%;
    `
  },
  container: (0, _react2.css)`
    .header__topBannerContainer {
      height: 100%;
      width: 100%;
    }
  `
};
const HeaderTopBanner = ({
  headerBanner$,
  position = 'fixed'
}) => {
  const headerBanner = (0, _useObservable.default)(headerBanner$, undefined);
  if (!headerBanner) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.root[position], styles.container, ({
      euiTheme
    }) => ({
      zIndex: euiTheme.levels.header
    })],
    "data-test-subj": "headerTopBanner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
    containerClassName: "header__topBannerContainer",
    display: "block",
    extension: headerBanner.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.HeaderTopBanner = HeaderTopBanner;