"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../lib");
var _status_expanded_row = require("./status_expanded_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/core/packages/apps/browser-internal/src/status/components/status_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const expandLabel = _i18n.i18n.translate('core.statusPage.statusTable.columns.expandRow.expandLabel', {
  defaultMessage: 'Expand'
});
const collapseLabel = _i18n.i18n.translate('core.statusPage.statusTable.columns.expandRow.collapseLabel', {
  defaultMessage: 'Collapse'
});
const StatusTable = ({
  statuses
}) => {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  if (!statuses) {
    return null;
  }
  const toggleDetails = item => {
    const newRowMap = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMap[item.id]) {
      delete newRowMap[item.id];
    } else {
      newRowMap[item.id] = /*#__PURE__*/_react.default.createElement(_status_expanded_row.StatusExpandedRow, {
        status: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 28
        }
      });
    }
    setItemIdToExpandedRowMap(newRowMap);
  };
  const tableColumns = [{
    field: 'state',
    name: _i18n.i18n.translate('core.statusPage.statusTable.columns.statusHeader', {
      defaultMessage: 'Status'
    }),
    render: state => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      "aria-hidden": true,
      color: state.uiColor,
      title: state.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }),
    width: '100px',
    align: 'center',
    sortable: row => (0, _lib.getLevelSortValue)(row)
  }, {
    field: 'id',
    name: _i18n.i18n.translate('core.statusPage.statusTable.columns.idHeader', {
      defaultMessage: 'ID'
    }),
    sortable: true
  }, {
    field: 'state',
    name: _i18n.i18n.translate('core.statusPage.statusTable.columns.statusSummaryHeader', {
      defaultMessage: 'Status summary'
    }),
    render: state => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 52
      }
    }, state.message)
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.statusPage.statusTable.columns.expandRowHeader",
      defaultMessage: "Expand row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    })),
    align: 'right',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": itemIdToExpandedRowMap[item.id] ? collapseLabel : expandLabel,
      iconType: itemIdToExpandedRowMap[item.id] ? 'arrowUp' : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: tableColumns,
    itemId: item => item.id,
    items: statuses,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    rowProps: ({
      state
    }) => ({
      className: `status-table-row-${state.uiColor}`
    }),
    sorting: {
      sort: {
        direction: 'asc',
        field: 'state'
      }
    },
    "data-test-subj": "statusBreakdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
exports.StatusTable = StatusTable;