"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runZeroDowntimeMigration = void 0;
var _utils = require("./utils");
var _migrate_index = require("./migrate_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const runZeroDowntimeMigration = async options => {
  const migratorConfigs = (0, _utils.buildMigratorConfigs)({
    kibanaIndexPrefix: options.kibanaIndexPrefix,
    typeRegistry: options.typeRegistry
  });
  return await Promise.all(migratorConfigs.map(async migratorConfig => {
    const startTime = performance.now();
    try {
      const result = await (0, _migrate_index.migrateIndex)({
        ...options,
        ...migratorConfig
      });
      const duration = performance.now() - startTime;
      options.meter.record(duration, {
        'kibana.saved_objects.migrations.migrator': migratorConfig.indexPrefix
      });
      return result;
    } catch (error) {
      const duration = performance.now() - startTime;
      options.meter.record(duration, {
        'kibana.saved_objects.migrations.migrator': migratorConfig.indexPrefix,
        'error.type': error.message // Ideally, we had codes for each error instead.
      });
      throw error;
    }
  }));
};
exports.runZeroDowntimeMigration = runZeroDowntimeMigration;