"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CONTROL_WIDTH_OPTIONS = exports.CONTROL_LAYOUT_OPTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONTROL_WIDTH_OPTIONS = exports.CONTROL_WIDTH_OPTIONS = [{
  id: `small`,
  'data-test-subj': 'control-editor-width-small',
  label: _i18n.i18n.translate('controls.controlGroup.management.layout.small', {
    defaultMessage: 'Small'
  })
}, {
  id: `medium`,
  'data-test-subj': 'control-editor-width-medium',
  label: _i18n.i18n.translate('controls.controlGroup.management.layout.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: `large`,
  'data-test-subj': 'control-editor-width-large',
  label: _i18n.i18n.translate('controls.controlGroup.management.layout.large', {
    defaultMessage: 'Large'
  })
}];
const CONTROL_LAYOUT_OPTIONS = exports.CONTROL_LAYOUT_OPTIONS = [{
  id: `oneLine`,
  'data-test-subj': 'control-editor-layout-oneLine',
  label: _i18n.i18n.translate('controls.controlGroup.management.labelPosition.inline', {
    defaultMessage: 'Inline'
  })
}, {
  id: `twoLine`,
  'data-test-subj': 'control-editor-layout-twoLine',
  label: _i18n.i18n.translate('controls.controlGroup.management.labelPosition.above', {
    defaultMessage: 'Above'
  })
}];