"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsEventStreamNames = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsEventStreamNames {
  constructor(baseName) {
    (0, _defineProperty2.default)(this, "base", void 0);
    (0, _defineProperty2.default)(this, "dataStream", void 0);
    (0, _defineProperty2.default)(this, "indexPattern", void 0);
    (0, _defineProperty2.default)(this, "indexTemplate", void 0);
    const EVENT_STREAM_SUFFIX = `-event-stream`;
    const dataStream = `${baseName}${EVENT_STREAM_SUFFIX}`;
    this.base = baseName;
    this.dataStream = dataStream;
    this.indexPattern = `${dataStream}*`;
    this.indexTemplate = `${dataStream}-template`;
  }
}
exports.EsEventStreamNames = EsEventStreamNames;