"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setLoadFromParameter = exports.removeLoadFromParameter = void 0;
var _queryString = _interopRequireDefault(require("query-string"));
var _lzString = require("lz-string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getBaseUrl() {
  return `${window.location.protocol}//${window.location.host}${window.location.pathname}`;
}
function parseQueryString() {
  const [hashRoute, queryString] = (window.location.hash || window.location.search || '').split('?');
  const parsedQueryString = _queryString.default.parse(queryString || '', {
    sort: false
  });
  return {
    hasHash: !!window.location.hash,
    hashRoute,
    queryString: parsedQueryString
  };
}
const setLoadFromParameter = value => {
  const baseUrl = getBaseUrl();
  const {
    hasHash,
    hashRoute,
    queryString
  } = parseQueryString();
  const consoleDataUri = (0, _lzString.compressToEncodedURIComponent)(value);
  queryString.load_from = `data:text/plain,${consoleDataUri}`;
  const params = `?${_queryString.default.stringify(queryString)}`;
  const newUrl = hasHash ? `${baseUrl}${hashRoute}${params}` : `${baseUrl}${params}`;
  window.history.pushState({
    path: newUrl
  }, '', newUrl);
};
exports.setLoadFromParameter = setLoadFromParameter;
const removeLoadFromParameter = () => {
  const baseUrl = getBaseUrl();
  const {
    hasHash,
    hashRoute,
    queryString
  } = parseQueryString();
  if (queryString.load_from) {
    delete queryString.load_from;
    const params = Object.keys(queryString).length ? `?${_queryString.default.stringify(queryString)}` : '';
    const newUrl = hasHash ? `${baseUrl}${hashRoute}${params}` : `${baseUrl}${params}`;
    window.history.pushState({
      path: newUrl
    }, '', newUrl);
  }
};
exports.removeLoadFromParameter = removeLoadFromParameter;