"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PastableMarkdownEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _files = require("../../../common/files");
var _paste_upload = require("./paste_upload");
var _editor = require("./editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/pastable_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PastableMarkdownEditorComponent = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  const {
    ariaLabel,
    field,
    caseId,
    editorId,
    disabledUiPlugins,
    'data-test-subj': dataTestSubj,
    owner
  } = props;
  const fileKindId = (0, _files.constructFileKindIdByOwner)(owner);
  const {
    isUploading,
    errors
  } = (0, _paste_upload.useImagePasteUpload)({
    editorRef: ref,
    field,
    caseId,
    owner,
    fileKindId
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    css: {
      visibility: isUploading ? 'visible' : 'hidden'
    },
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, {
    ref: ref,
    ariaLabel: ariaLabel,
    editorId: editorId,
    onChange: field.setValue,
    value: field.value,
    disabledUiPlugins: disabledUiPlugins,
    "data-test-subj": `${dataTestSubj}-markdown-editor`,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }));
});
PastableMarkdownEditorComponent.displayName = 'PastableMarkdownEditor';
const PastableMarkdownEditor = exports.PastableMarkdownEditor = /*#__PURE__*/_react.default.memo(PastableMarkdownEditorComponent);