"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _connector = require("../case_form_fields/connector");
var i18n = _interopRequireWildcard(require("./translations"));
var _sync_alerts_toggle = require("../case_form_fields/sync_alerts_toggle");
var _utils = require("../utils");
var _use_cases_features = require("../../common/use_cases_features");
var _templates = require("./templates");
var _utils2 = require("./utils");
var _case_form_fields = require("../case_form_fields");
var _builder = require("../custom_fields/builder");
var _observables_toggle = require("../case_form_fields/observables_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/create/form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const transformTemplateCaseFieldsToCaseFormFields = (owner, caseTemplateFields) => {
  var _caseFields$customFie;
  const caseFields = (0, _utils.removeEmptyFields)(caseTemplateFields !== null && caseTemplateFields !== void 0 ? caseTemplateFields : {});
  const transFormedCustomFields = caseFields === null || caseFields === void 0 ? void 0 : (_caseFields$customFie = caseFields.customFields) === null || _caseFields$customFie === void 0 ? void 0 : _caseFields$customFie.map(customField => {
    const customFieldFactory = _builder.builderMap[customField.type];
    const {
      convertNullToEmpty
    } = customFieldFactory();
    const value = convertNullToEmpty ? convertNullToEmpty(customField.value) : customField.value;
    return {
      ...customField,
      value
    };
  });
  return (0, _utils2.getInitialCaseValue)({
    owner,
    ...caseFields,
    customFields: transFormedCustomFields
  });
};
const DEFAULT_EMPTY_TEMPLATE_KEY = 'defaultEmptyTemplateKey';
const CreateCaseFormFields = exports.CreateCaseFormFields = /*#__PURE__*/_react.default.memo(({
  configuration,
  connectors,
  isLoading,
  withSteps,
  draftStorageKey
}) => {
  const {
    reset,
    updateFieldValues,
    isSubmitting,
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const {
    isSyncAlertsEnabled,
    isExtractObservablesEnabled,
    observablesAuthorized,
    connectorsAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const canExtractObservables = observablesAuthorized && isExtractObservablesEnabled;
  const configurationOwner = configuration.owner;

  /**
   * Changes the selected connector
   * when the user selects a solution.
   * Each solution has its own configuration
   * so the connector has to change.
   */
  (0, _react.useEffect)(() => {
    setFieldValue('connectorId', configuration.connector.id);
  }, [configuration.connector.id, setFieldValue]);
  const defaultTemplate = (0, _react.useMemo)(() => ({
    key: DEFAULT_EMPTY_TEMPLATE_KEY,
    name: i18n.DEFAULT_EMPTY_TEMPLATE_NAME,
    caseFields: (0, _utils2.getInitialCaseValue)({
      owner: configurationOwner,
      connector: configuration.connector
    })
  }), [configurationOwner, configuration.connector]);
  const onTemplateChange = (0, _react.useCallback)(({
    caseFields
  }) => {
    const caseFormFields = transformTemplateCaseFieldsToCaseFormFields(configurationOwner, caseFields);
    reset({
      resetValues: true,
      defaultValue: (0, _utils2.getInitialCaseValue)({
        owner: configurationOwner
      })
    });
    updateFieldValues(caseFormFields);
  }, [configurationOwner, reset, updateFieldValues]);
  const firstStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_ONE_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_templates.TemplateSelector, {
      isLoading: isSubmitting || isLoading,
      templates: [defaultTemplate, ...configuration.templates],
      onTemplateChange: onTemplateChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    })
  }), [configuration.templates, defaultTemplate, isLoading, isSubmitting, onTemplateChange]);
  const secondStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_TWO_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_case_form_fields.CaseFormFields, {
      configurationCustomFields: configuration.customFields,
      isLoading: isSubmitting,
      setCustomFieldsOptional: false,
      isEditMode: false,
      draftStorageKey: draftStorageKey,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    })
  }), [configuration.customFields, draftStorageKey, isSubmitting]);
  const showThirdStep = isSyncAlertsEnabled || canExtractObservables;
  const thirdStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_THREE_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSyncAlertsEnabled && /*#__PURE__*/_react.default.createElement(_sync_alerts_toggle.SyncAlertsToggle, {
      isLoading: isSubmitting,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 37
      }
    }), canExtractObservables && /*#__PURE__*/_react.default.createElement(_observables_toggle.ObservablesToggle, {
      isLoading: isSubmitting,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 39
      }
    }))
  }), [isSubmitting, isSyncAlertsEnabled, canExtractObservables]);
  const fourthStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_FOUR_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_connector.Connector, {
      connectors: connectors,
      isLoadingConnectors: isLoading,
      isLoading: isSubmitting,
      key: configuration.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    })
  }), [configuration.id, connectors, isLoading, isSubmitting]);
  const allSteps = (0, _react.useMemo)(() => [firstStep, secondStep, ...(showThirdStep ? [thirdStep] : []), ...(connectorsAuthorized ? [fourthStep] : [])], [firstStep, secondStep, showThirdStep, thirdStep, connectorsAuthorized, fourthStep]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSubmitting && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: (0, _react2.css)`
              position: absolute;
              top: 50%;
              left: 50%;
              z-index: 99;
            `,
    "data-test-subj": "create-case-loading-spinner",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }), withSteps ? /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: allSteps,
    "data-test-subj": 'case-creation-form-steps',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 21
    }
  }, i18n.STEP_ONE_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 17
    }
  }, firstStep.children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 21
    }
  }, i18n.STEP_TWO_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }, secondStep.children)), showThirdStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 23
    }
  }, i18n.STEP_THREE_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }, thirdStep.children)), connectorsAuthorized && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 23
    }
  }, i18n.STEP_FOUR_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 19
    }
  }, fourthStep.children)))));
});
CreateCaseFormFields.displayName = 'CreateCaseFormFields';