"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateJSONValidator = void 0;
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ADDITIONAL_FIELDS_LENGTH = 10;
const generateJSONValidator = options => (...args) => {
  var _options$maxAdditiona;
  const [{
    value
  }] = args;
  const maxAdditionalFields = (_options$maxAdditiona = options === null || options === void 0 ? void 0 : options.maxAdditionalFields) !== null && _options$maxAdditiona !== void 0 ? _options$maxAdditiona : MAX_ADDITIONAL_FIELDS_LENGTH;
  try {
    if (typeof value === 'string' && !(0, _lodash.isEmpty)(value)) {
      const parsedJSON = JSON.parse(value);
      if (!(0, _lodash.isObject)(parsedJSON)) {
        return {
          code: 'ERR_JSON_FORMAT',
          message: i18n.INVALID_JSON_FORMAT
        };
      }
      if (Object.keys(parsedJSON).length > maxAdditionalFields) {
        return {
          code: 'ERR_JSON_FORMAT',
          message: i18n.MAX_ATTRIBUTES_ERROR(maxAdditionalFields)
        };
      }
    }
  } catch (error) {
    return {
      code: 'ERR_JSON_FORMAT',
      message: i18n.INVALID_JSON_FORMAT
    };
  }
};
exports.generateJSONValidator = generateJSONValidator;