"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/configure_cases/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonFlyout = ({
  onCloseFlyout,
  onSaveField,
  isLoading,
  disabled,
  renderHeader,
  children
}) => {
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    })
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    submit
  } = formState;
  const handleSaveField = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid) {
      /**
       * The serializer transforms the data
       * from the form format to the backend
       * format. The I generic is the correct
       * format of the data.
       */
      onSaveField(data);
    }
  }, [onSaveField, submit]);

  /**
   * The children will call setFormState which in turn will make the parent
   * to rerender which in turn will rerender the children etc.
   * To avoid an infinitive loop we need to memoize the children.
   */
  const memoizedChildren = (0, _react.useMemo)(() => children({
    onChange: setFormState
  }), [children]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCloseFlyout,
    "aria-labelledby": modalTitleId,
    "data-test-subj": "common-flyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "common-flyout-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, renderHeader()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, memoizedChildren), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": 'common-flyout-footer',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCloseFlyout,
    "data-test-subj": 'common-flyout-cancel',
    disabled: disabled,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleSaveField,
    "data-test-subj": 'common-flyout-save',
    disabled: disabled,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, i18n.SAVE))))));
};
exports.CommonFlyout = CommonFlyout;
CommonFlyout.displayName = 'CommonFlyout';