"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewActivity = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _use_cases_local_storage = require("../../../common/use_cases_local_storage");
var _use_get_case_configuration = require("../../../containers/configure/use_get_case_configuration");
var _use_get_case_users = require("../../../containers/use_get_case_users");
var _use_get_case_connectors = require("../../../containers/use_get_case_connectors");
var _use_cases_features = require("../../../common/use_cases_features");
var _use_get_current_user_profile = require("../../../containers/user_profiles/use_get_current_user_profile");
var _use_get_supported_action_connectors = require("../../../containers/configure/use_get_supported_action_connectors");
var _edit_connector = require("../../edit_connector");
var _button = require("../../status/button");
var _edit_tags = require("./edit_tags");
var _user_actions = require("../../user_actions");
var _user_list = require("./user_list");
var _use_on_update_field = require("../use_on_update_field");
var _use_cases_context = require("../../cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("../translations"));
var _sidebar_selector = require("../../severity/sidebar_selector");
var _use_get_case_user_actions_stats = require("../../../containers/use_get_case_user_actions_stats");
var _assign_users = require("./assign_users");
var _user_actions_activity_bar = require("../../user_actions_activity_bar");
var _types = require("../../../../common/types");
var _case_view_tabs = require("../case_view_tabs");
var _description = require("../../description");
var _edit_category = require("./edit_category");
var _utils = require("../../utils");
var _custom_fields = require("./custom_fields");
var _use_replace_custom_field = require("../../../containers/use_replace_custom_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_activity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOCALSTORAGE_SORT_ORDER_KEY = 'cases.userActivity.sortOrder';
const CaseViewActivity = ({
  ruleDetailsNavigation,
  caseData,
  actionsNavigation,
  showAlertDetails,
  useFetchAlertData
}) => {
  const [sortOrder, setSortOrder] = (0, _use_cases_local_storage.useCasesLocalStorage)(LOCALSTORAGE_SORT_ORDER_KEY, 'asc');
  const [userActivityQueryParams, setUserActivityQueryParams] = (0, _react2.useState)({
    type: 'all',
    sortOrder,
    page: 1,
    perPage: 10
  });
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    caseAssignmentAuthorized,
    pushToServiceAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: caseConnectors,
    isLoading: isLoadingCaseConnectors
  } = (0, _use_get_case_connectors.useGetCaseConnectors)(caseData.id);
  const {
    data: userActionsStats,
    isLoading: isLoadingUserActionsStats
  } = (0, _use_get_case_user_actions_stats.useGetCaseUserActionsStats)(caseData.id);
  const {
    data: caseUsers,
    isLoading: isLoadingCaseUsers
  } = (0, _use_get_case_users.useGetCaseUsers)(caseData.id);
  const {
    data: casesConfiguration
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const {
    userProfiles,
    reporterAsArray
  } = (0, _utils.parseCaseUsers)({
    caseUsers,
    createdBy: caseData.createdBy
  });
  const assignees = (0, _react2.useMemo)(() => caseData.assignees.map(assignee => assignee.uid), [caseData.assignees]);
  const {
    data: currentUserProfile,
    isFetching: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    onUpdateField,
    isLoading,
    loadingKey
  } = (0, _use_on_update_field.useOnUpdateField)({
    caseData
  });
  const {
    isLoading: isUpdatingCustomField,
    mutate: replaceCustomField
  } = (0, _use_replace_custom_field.useReplaceCustomField)();
  const isLoadingAssigneeData = isLoading && loadingKey === 'assignees' || isLoadingCaseUsers || isLoadingCurrentUserProfile;
  const changeStatus = (0, _react2.useCallback)(status => onUpdateField({
    key: 'status',
    value: status
  }), [onUpdateField]);
  const onSubmitTags = (0, _react2.useCallback)(newTags => onUpdateField({
    key: 'tags',
    value: newTags
  }), [onUpdateField]);
  const onSubmitCategory = (0, _react2.useCallback)(newCategory => onUpdateField({
    key: 'category',
    value: newCategory
  }), [onUpdateField]);
  const onUpdateSeverity = (0, _react2.useCallback)(newSeverity => onUpdateField({
    key: 'severity',
    value: newSeverity
  }), [onUpdateField]);
  const onUpdateAssignees = (0, _react2.useCallback)(newAssignees => {
    const newAssigneeUids = newAssignees.map(assignee => ({
      uid: assignee.uid
    }));
    if (!(0, _lodash.isEqual)(newAssigneeUids.sort(), assignees.sort())) {
      onUpdateField({
        key: 'assignees',
        value: newAssigneeUids
      });
    }
  }, [assignees, onUpdateField]);
  const {
    isLoading: isLoadingAllAvailableConnectors,
    data: supportedActionConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const onSubmitConnector = (0, _react2.useCallback)(connector => {
    onUpdateField({
      key: 'connector',
      value: connector
    });
  }, [onUpdateField]);
  const onSubmitCustomField = (0, _react2.useCallback)(customField => {
    replaceCustomField({
      caseId: caseData.id,
      customFieldId: customField.key,
      customFieldValue: customField.value,
      caseVersion: caseData.version
    });
  }, [replaceCustomField, caseData]);
  const handleUserActionsActivityChanged = (0, _react2.useCallback)(params => {
    setSortOrder(params.sortOrder);
    setUserActivityQueryParams(oldParams => ({
      ...oldParams,
      page: 1,
      type: params.type,
      sortOrder: params.sortOrder
    }));
  }, [setSortOrder, setUserActivityQueryParams]);
  const showUserActions = !isLoadingUserActionsStats && !isLoadingCaseConnectors && !isLoadingCaseUsers && caseConnectors && caseUsers && userActionsStats;
  const showConnectorSidebar = pushToServiceAuthorized && caseConnectors && supportedActionConnectors;
  const isLoadingDescription = isLoading && loadingKey === 'description';
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    css: (0, _react.css)`
          max-width: 75%;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.ACTIVITY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_description.Description, {
    isLoadingDescription: isLoadingDescription,
    caseData: caseData,
    onUpdateField: onUpdateField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_user_actions_activity_bar.UserActionsActivityBar, {
    onUserActionsActivityChanged: handleUserActionsActivityChanged,
    params: userActivityQueryParams,
    userActionsStats: userActionsStats,
    isLoading: isLoadingUserActionsStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }), (isLoadingUserActionsStats || isLoadingCaseConnectors || isLoadingCaseUsers) && /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "case-view-loading-content",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }), showUserActions ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    "data-test-subj": "case-view-activity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_user_actions.UserActions, {
    userProfiles: userProfiles,
    currentUserProfile: currentUserProfile,
    getRuleDetailsHref: ruleDetailsNavigation === null || ruleDetailsNavigation === void 0 ? void 0 : ruleDetailsNavigation.href,
    onRuleDetailsClick: ruleDetailsNavigation === null || ruleDetailsNavigation === void 0 ? void 0 : ruleDetailsNavigation.onClick,
    caseConnectors: caseConnectors,
    data: caseData,
    casesConfiguration: casesConfiguration,
    actionsNavigation: actionsNavigation,
    onShowAlertDetails: showAlertDetails,
    onUpdateField: onUpdateField,
    statusActionButton: permissions.update ? /*#__PURE__*/_react2.default.createElement(_button.StatusActionButton, {
      status: caseData.status,
      onStatusChanged: changeStatus,
      isLoading: isLoading && loadingKey === 'status',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 21
      }
    }) : null,
    useFetchAlertData: useFetchAlertData,
    userActivityQueryParams: userActivityQueryParams,
    userActionsStats: userActionsStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }))) : null), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    "data-test-subj": "case-view-page-sidebar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, i18n.CASE_SETTINGS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }, caseAssignmentAuthorized ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_assign_users.AssignUsers, {
    caseAssignees: caseData.assignees,
    currentUserProfile: currentUserProfile,
    onAssigneesChanged: onUpdateAssignees,
    isLoading: isLoadingAssigneeData,
    userProfiles: userProfiles !== null && userProfiles !== void 0 ? userProfiles : new Map(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react2.default.createElement(_sidebar_selector.SeveritySidebarSelector, {
    isDisabled: !permissions.update,
    isLoading: isLoading && loadingKey === 'severity',
    selectedSeverity: caseData.severity,
    onSeverityChange: onUpdateSeverity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_user_list.UserList, {
    dataTestSubj: "case-view-user-list-reporter",
    theCase: caseData,
    headline: i18n.REPORTER,
    users: reporterAsArray,
    userProfiles: userProfiles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  }), caseUsers != null ? /*#__PURE__*/_react2.default.createElement(_user_list.UserList, {
    dataTestSubj: "case-view-user-list-participants",
    theCase: caseData,
    headline: i18n.PARTICIPANTS,
    loading: isLoadingCaseUsers,
    users: [...caseUsers.participants, ...caseUsers.assignees],
    userProfiles: userProfiles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_edit_tags.EditTags, {
    tags: caseData.tags,
    onSubmit: onSubmitTags,
    isLoading: isLoading && loadingKey === 'tags',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_edit_category.EditCategory, {
    category: caseData.category,
    onSubmit: onSubmitCategory,
    isLoading: isLoading && loadingKey === 'category',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  }), showConnectorSidebar ? /*#__PURE__*/_react2.default.createElement(_edit_connector.EditConnector, {
    caseData: caseData,
    caseConnectors: caseConnectors,
    supportedActionConnectors: supportedActionConnectors,
    isLoading: isLoadingAllAvailableConnectors || isLoading && loadingKey === 'connector',
    onSubmit: onSubmitConnector,
    key: caseData.connector.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_custom_fields.CustomFields, {
    isLoading: isLoading && loadingKey === 'customFields' || isUpdatingCustomField,
    customFields: caseData.customFields,
    customFieldsConfiguration: casesConfiguration.customFields,
    onSubmit: onSubmitCustomField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }))));
};
exports.CaseViewActivity = CaseViewActivity;
CaseViewActivity.displayName = 'CaseViewActivity';