"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeCasesSimilarResponse = exports.decodeCasesMetricsResponse = exports.decodeCasesFindResponse = exports.decodeCasesBulkGetResponse = void 0;
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _pipeable = require("fp-ts/pipeable");
var _api = require("../../common/types/api");
var _utils = require("../containers/utils");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const decodeCasesFindResponse = respCases => (0, _pipeable.pipe)(_api.CasesFindResponseRt.decode(respCases), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesFindResponse = decodeCasesFindResponse;
const decodeCasesMetricsResponse = metrics => (0, _pipeable.pipe)(_api.CasesMetricsResponseRt.decode(metrics), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesMetricsResponse = decodeCasesMetricsResponse;
const decodeCasesBulkGetResponse = res => {
  (0, _pipeable.pipe)(_api.CasesBulkGetResponseRt.decode(res), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
  return res;
};
exports.decodeCasesBulkGetResponse = decodeCasesBulkGetResponse;
const decodeCasesSimilarResponse = respCases => (0, _pipeable.pipe)(_api.CasesSimilarResponseRt.decode(respCases), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesSimilarResponse = decodeCasesSimilarResponse;