"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WorkpadsContext = exports.MyWorkpads = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
var _loading = require("../loading");
var _my_workpads = require("./my_workpads.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/home/my_workpads/my_workpads.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadsContext = exports.WorkpadsContext = /*#__PURE__*/(0, _react.createContext)(null);
const MyWorkpads = () => {
  const findWorkpads = (0, _hooks.useFindWorkpads)();
  const [isMounted, setIsMounted] = (0, _react.useState)(false);
  const [workpads, setWorkpads] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const mount = async () => {
      const response = await findWorkpads('');
      setIsMounted(true);
      setWorkpads((response === null || response === void 0 ? void 0 : response.workpads) || []);
    };
    mount();
  }, [setIsMounted, findWorkpads]);
  if (!isMounted) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(WorkpadsContext.Provider, {
    value: {
      workpads,
      setWorkpads
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_my_workpads.MyWorkpads, {
    workpads,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.MyWorkpads = MyWorkpads;
var _default = exports.default = MyWorkpads;