"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPickerPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _popover = require("../popover");
var _color_dot = require("../color_dot");
var _color_picker = require("../color_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/color_picker_popover/color_picker_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorPickerPopover = props => {
  const {
    value,
    anchorPosition,
    ariaLabel,
    ...rest
  } = props;
  const button = handleClick => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": `${ariaLabel} ${value ? (0, _chromaJs.default)(value).name() : value}`,
    css: {
      fontSize: 0
    },
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_color_dot.ColorDot, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    id: "color-picker-popover",
    panelClassName: "canvas canvasColorPickerPopover__popover",
    button: button,
    anchorPosition: anchorPosition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, () => /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, (0, _extends2.default)({
    value: value
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 14
    }
  })));
};
exports.ColorPickerPopover = ColorPickerPopover;
ColorPickerPopover.propTypes = {
  ..._color_picker.ColorPicker.propTypes,
  anchorPosition: _propTypes.default.string
};