"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/arg_label.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This is what is being generated by render() from the Arg class. It is called in FunctionForm

const ArgLabel = props => {
  const {
    argId,
    className,
    label,
    help,
    expandable,
    children,
    simpleArg,
    initialIsOpen
  } = props;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `canvasArg--header${className && ` ${className}`}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, expandable ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `accordion-${argId}`,
    className: "canvasSidebar__accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: help,
      position: "left",
      className: "canvasArg__tooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 15
      }
    }, label)),
    extraAction: simpleArg,
    initialIsOpen: initialIsOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  }, children)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: help,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 15
      }
    }, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 25
      }
    }))),
    id: argId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, simpleArg || children));
};
exports.ArgLabel = ArgLabel;
ArgLabel.propTypes = {
  argId: _propTypes.default.string,
  label: _propTypes.default.string,
  help: _propTypes.default.string,
  expandable: _propTypes.default.bool,
  initialIsOpen: _propTypes.default.bool,
  simpleArg: _propTypes.default.object,
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.element]).isRequired,
  className: _propTypes.default.string
};