"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateDisplayAuthToType = exports.ConfirmSettingsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _oas = require("../../../../../../../util/oas");
var _common = require("../../../../../../../common");
var _state = require("../../../../state");
var i18n = _interopRequireWildcard(require("./translations"));
var _endpoint_selection = require("./endpoint_selection");
var _auth_selection = require("./auth_selection");
var _generation_error = require("../../generation_error");
var _telemetry = require("../../../../../telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/flyout/cel_configuration/steps/confirm_settings_step/confirm_settings_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const translateDisplayAuthToType = auth => {
  return auth === 'API Token' ? 'Header' : auth;
};
exports.translateDisplayAuthToType = translateDisplayAuthToType;
const API_TOKEN_OAS_AUTH_TYPES = ['Header', 'Bearer', 'apiKey'];
const translateAuthTypeToDisplay = auth => {
  return API_TOKEN_OAS_AUTH_TYPES.includes(auth) ? 'API Token' : auth;
};
const getSpecifiedAuthForPath = (apiSpec, path) => {
  const authMethods = apiSpec === null || apiSpec === void 0 ? void 0 : apiSpec.operation(path, 'get').prepareSecurity();
  const specifiedAuth = authMethods ? Object.keys(authMethods).map(auth => API_TOKEN_OAS_AUTH_TYPES.includes(auth) ? 'API Token' : auth) : [];
  return specifiedAuth;
};
const loadPaths = integrationSettings => {
  var _integrationSettings$;
  const pathObjs = integrationSettings === null || integrationSettings === void 0 ? void 0 : (_integrationSettings$ = integrationSettings.apiSpec) === null || _integrationSettings$ === void 0 ? void 0 : _integrationSettings$.getPaths();
  if (!pathObjs) {
    return [];
  }
  return Object.keys(pathObjs).filter(path => pathObjs[path].get);
};
const ConfirmSettingsStep = exports.ConfirmSettingsStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  connector,
  isFlyoutGenerating,
  suggestedPaths,
  showValidation,
  onShowValidation,
  onUpdateValidation,
  onUpdateNeedsGeneration,
  onCelInputGenerationComplete
}) => {
  const {
    setIsFlyoutGenerating
  } = (0, _state.useActions)();
  const {
    http,
    notifications
  } = (0, _common.useKibana)().services;
  const {
    reportCelGenerationComplete
  } = (0, _telemetry.useTelemetry)();
  const [selectedPath, setSelectedPath] = (0, _react.useState)(() => suggestedPaths ? suggestedPaths[0] : '');
  const [selectedOtherPath, setSelectedOtherPath] = (0, _react.useState)();
  const [useOtherPath, setUseOtherPath] = (0, _react.useState)(false);
  const coalescedSelectedPath = !useOtherPath ? selectedPath : selectedOtherPath;
  const [selectedAuth, setSelectedAuth] = (0, _react.useState)(() => {
    const recommendedPath = suggestedPaths ? suggestedPaths[0] : '';
    if (recommendedPath) {
      const specifiedAuth = getSpecifiedAuthForPath(integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.apiSpec, recommendedPath);
      return translateAuthTypeToDisplay(specifiedAuth[0]);
    }
  });
  const [specifiedAuthForPath, setSpecifiedAuthForPath] = (0, _react.useState)([]);
  const [unspecifiedAuth, setUnspecifiedAuth] = (0, _react.useState)(false);
  const [successfulGeneration, setSuccessfulGeneration] = (0, _react.useState)(false);
  const [generatedPair, setGeneratedPair] = (0, _react.useState)({
    path: undefined,
    auth: undefined
  });
  const [error, setError] = (0, _react.useState)(null);
  const [fieldValidationErrors, setFieldValidationErrors] = (0, _react.useState)({
    path: false,
    auth: false
  });
  const isSelectedPathGenerated = generatedPair.path === coalescedSelectedPath && generatedPair.auth === (selectedAuth && translateDisplayAuthToType(selectedAuth).toLowerCase());

  // updates the specified auth methods when the selected path is modified
  (0, _react.useEffect)(() => {
    const path = coalescedSelectedPath;
    if (path) {
      const specifiedAuth = getSpecifiedAuthForPath(integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.apiSpec, path);
      setSpecifiedAuthForPath(specifiedAuth);
    }
  }, [coalescedSelectedPath, integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.apiSpec]);
  (0, _react.useEffect)(() => {
    onUpdateValidation(!fieldValidationErrors.path && !fieldValidationErrors.auth);
  }, [fieldValidationErrors, onUpdateValidation]);
  const onChangeSuggestedPath = (0, _react.useCallback)(path => {
    setSelectedPath(path);
    setUseOtherPath(path === i18n.ENTER_MANUALLY);
    if (path !== i18n.ENTER_MANUALLY) {
      setSelectedOtherPath(undefined);
    }
  }, [setSelectedPath, setUseOtherPath]);
  const onChangeOtherPath = (0, _react.useCallback)(field => {
    var _field$;
    const path = field === null || field === void 0 ? void 0 : (_field$ = field[0]) === null || _field$ === void 0 ? void 0 : _field$.label;
    setSelectedOtherPath(path);
    setFieldValidationErrors(current => ({
      ...current,
      path: path === undefined
    }));
  }, [setSelectedOtherPath]);
  const onChangeAuth = (0, _react.useCallback)(field => {
    const auth = field && field.length ? field[0].label : undefined;
    setSelectedAuth(auth);
    if (auth) {
      if (specifiedAuthForPath) {
        setUnspecifiedAuth(!specifiedAuthForPath.includes(auth));
      }
      setFieldValidationErrors(current => ({
        ...current,
        auth: false
      }));
    } else {
      setUnspecifiedAuth(false);
      setFieldValidationErrors(current => ({
        ...current,
        auth: true
      }));
    }
  }, [specifiedAuthForPath]);
  const onGenerate = (0, _react.useCallback)(() => {
    if (fieldValidationErrors.path || fieldValidationErrors.auth) {
      onShowValidation();
      return;
    }
    if (http == null || connector == null || integrationSettings == null || (notifications === null || notifications === void 0 ? void 0 : notifications.toasts) == null || coalescedSelectedPath == null || selectedAuth == null) {
      return;
    }
    setError(null);
    onUpdateNeedsGeneration(false);
    const generationStartedAt = Date.now();
    const abortController = new AbortController();
    const deps = {
      http,
      abortSignal: abortController.signal
    };
    (async () => {
      try {
        var _integrationSettings$2, _schemas;
        setIsFlyoutGenerating(true);
        const oas = integrationSettings.apiSpec;
        if (!oas) {
          throw new Error('Missing OpenAPI spec');
        }
        const path = coalescedSelectedPath;
        const auth = translateDisplayAuthToType(selectedAuth).toLowerCase();
        if (!path || !auth) {
          throw new Error('Missing path and auth selections');
        }
        const endpointOperation = oas === null || oas === void 0 ? void 0 : oas.operation(path, 'get');
        if (!endpointOperation) {
          throw new Error('Selected path is not found in OpenApi specification');
        }
        const authOptions = endpointOperation === null || endpointOperation === void 0 ? void 0 : endpointOperation.prepareSecurity();
        const endpointAuth = (0, _oas.getAuthDetails)(auth, authOptions);
        let schemas;
        try {
          schemas = (0, _oas.reduceSpecComponents)(oas, path);
        } catch (parsingError) {
          throw new Error('Error parsing OpenAPI spec for required components');
        }
        const celRequest = {
          dataStreamTitle: (_integrationSettings$2 = integrationSettings.dataStreamTitle) !== null && _integrationSettings$2 !== void 0 ? _integrationSettings$2 : '',
          celDetails: {
            path,
            auth,
            openApiDetails: {
              operation: JSON.stringify(endpointOperation.schema),
              auth: JSON.stringify(endpointAuth),
              schemas: JSON.stringify((_schemas = schemas) !== null && _schemas !== void 0 ? _schemas : {})
            }
          },
          connectorId: connector.id,
          langSmithOptions: (0, _common.getLangSmithOptions)()
        };
        const celGraphResult = await (0, _common.runCelGraph)(celRequest, deps);
        if (abortController.signal.aborted) return;
        if ((0, _fp.isEmpty)(celGraphResult === null || celGraphResult === void 0 ? void 0 : celGraphResult.results)) {
          throw new Error('Results not found in response');
        }
        reportCelGenerationComplete({
          connector,
          integrationSettings,
          durationMs: Date.now() - generationStartedAt
        });
        const result = {
          authType: auth,
          program: celGraphResult.results.program,
          needsAuthConfigBlock: celGraphResult === null || celGraphResult === void 0 ? void 0 : celGraphResult.results.needsAuthConfigBlock,
          stateSettings: celGraphResult.results.stateSettings,
          configFields: celGraphResult.results.configFields,
          redactVars: celGraphResult.results.redactVars,
          url: oas.url()
        };
        onCelInputGenerationComplete(path, auth, result);
        setSuccessfulGeneration(true);
        setGeneratedPair({
          path,
          auth
        });
      } catch (e) {
        if (abortController.signal.aborted) return;
        const errorMessage = `${e.message}${e.body ? ` (${e.body.statusCode}): ${e.body.message}` : ''}`;
        reportCelGenerationComplete({
          connector,
          integrationSettings,
          durationMs: Date.now() - generationStartedAt,
          error: errorMessage
        });
        setError(errorMessage);
        onUpdateValidation(!!errorMessage);
        onUpdateNeedsGeneration(true);
      } finally {
        setIsFlyoutGenerating(false);
      }
    })();
    return () => {
      abortController.abort();
    };
  }, [fieldValidationErrors.path, fieldValidationErrors.auth, http, connector, integrationSettings, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, coalescedSelectedPath, selectedAuth, onUpdateNeedsGeneration, onShowValidation, setIsFlyoutGenerating, reportCelGenerationComplete, onCelInputGenerationComplete, onUpdateValidation]);
  const onCancel = (0, _react.useCallback)(() => {
    setIsFlyoutGenerating(false); // aborts generation
    onUpdateNeedsGeneration(true);
  }, [onUpdateNeedsGeneration, setIsFlyoutGenerating]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "data-test-subj": "confirmSettingsStep",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint_selection.EndpointSelection, {
    allPaths: loadPaths(integrationSettings),
    pathSuggestions: suggestedPaths,
    selectedPath: selectedPath,
    selectedOtherPath: selectedOtherPath,
    useOtherEndpoint: useOtherPath,
    isGenerating: isFlyoutGenerating,
    showValidation: showValidation,
    onChangeSuggestedPath: onChangeSuggestedPath,
    onChangeOtherPath: onChangeOtherPath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_auth_selection.AuthSelection, {
    selectedAuth: selectedAuth,
    specifiedAuthForPath: specifiedAuthForPath,
    invalidAuth: unspecifiedAuth,
    showValidation: showValidation,
    isGenerating: isFlyoutGenerating,
    onChangeAuth: onChangeAuth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  }), successfulGeneration && isSelectedPathGenerated ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.SUCCESS,
    color: "success",
    iconType: "check",
    "data-test-subj": "successCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 13
    }
  }) : error ? /*#__PURE__*/_react.default.createElement(_generation_error.GenerationError, {
    title: i18n.GENERATION_ERROR,
    error: error,
    retryAction: onGenerate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    fullWidth: false,
    isDisabled: isFlyoutGenerating || showValidation && (fieldValidationErrors.path || fieldValidationErrors.auth),
    isLoading: isFlyoutGenerating,
    iconSide: "right",
    color: "primary",
    onClick: onGenerate,
    "data-test-subj": "generateCelInputButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 15
    }
  }, isFlyoutGenerating ? i18n.GENERATING : i18n.GENERATE), isFlyoutGenerating && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    flush: "left",
    "data-test-subj": "cancelCelGenerationButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 17
    }
  }, i18n.CANCEL))));
});
ConfirmSettingsStep.displayName = 'ConfirmSettingsStep';