"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultEnvironment = useDefaultEnvironment;
var _common = require("@kbn/observability-plugin/common");
var _environment_filter_values = require("../../common/environment_filter_values");
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDefaultEnvironment() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const defaultServiceEnvironment = core.uiSettings.get(_common.defaultApmServiceEnvironment) || _environment_filter_values.ENVIRONMENT_ALL.value;
  return defaultServiceEnvironment;
}